import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ContainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cluster_ipv4_cidr ContainerCluster#cluster_ipv4_cidr}
     *
     * @stability stable
     */
    readonly clusterIpv4Cidr?: string;
    /**
     * The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#datapath_provider ContainerCluster#datapath_provider}
     *
     * @stability stable
     */
    readonly datapathProvider?: string;
    /**
     * The default maximum number of pods per node in this cluster.
     *
     * This doesn't work on "routes-based" clusters, clusters that don't have IP Aliasing enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#default_max_pods_per_node ContainerCluster#default_max_pods_per_node}
     *
     * @stability stable
     */
    readonly defaultMaxPodsPerNode?: number;
    /**
     * Description of the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#description ContainerCluster#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Enable Autopilot for this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_autopilot ContainerCluster#enable_autopilot}
     *
     * @stability stable
     */
    readonly enableAutopilot?: boolean;
    /**
     * Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_binary_authorization ContainerCluster#enable_binary_authorization}
     *
     * @stability stable
     */
    readonly enableBinaryAuthorization?: boolean;
    /**
     * Whether Intra-node visibility is enabled for this cluster.
     *
     * This makes same node pod to pod traffic visible for VPC network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_intranode_visibility ContainerCluster#enable_intranode_visibility}
     *
     * @stability stable
     */
    readonly enableIntranodeVisibility?: boolean;
    /**
     * Whether to enable Kubernetes Alpha features for this cluster.
     *
     * Note that when this option is enabled, the cluster cannot be upgraded and will be automatically deleted after 30 days.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_kubernetes_alpha ContainerCluster#enable_kubernetes_alpha}
     *
     * @stability stable
     */
    readonly enableKubernetesAlpha?: boolean;
    /**
     * Whether the ABAC authorizer is enabled for this cluster.
     *
     * When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_legacy_abac ContainerCluster#enable_legacy_abac}
     *
     * @stability stable
     */
    readonly enableLegacyAbac?: boolean;
    /**
     * Enable Shielded Nodes features on all nodes in this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_shielded_nodes ContainerCluster#enable_shielded_nodes}
     *
     * @stability stable
     */
    readonly enableShieldedNodes?: boolean;
    /**
     * Whether to enable Cloud TPU resources in this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_tpu ContainerCluster#enable_tpu}
     *
     * @stability stable
     */
    readonly enableTpu?: boolean;
    /**
     * The number of nodes to create in this cluster's default node pool.
     *
     * In regional or multi-zonal clusters, this is the number of nodes per zone. Must be set if node_pool is not set. If you're using google_container_node_pool objects with no default node pool, you'll need to set this to a value of at least 1, alongside setting remove_default_node_pool to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#initial_node_count ContainerCluster#initial_node_count}
     *
     * @stability stable
     */
    readonly initialNodeCount?: number;
    /**
     * The location (region or zone) in which the cluster master will be created, as well as the default node location.
     *
     * If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#location ContainerCluster#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * The logging service that the cluster should write logs to.
     *
     * Available options include logging.googleapis.com(Legacy Stackdriver), logging.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Logging), and none. Defaults to logging.googleapis.com/kubernetes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#logging_service ContainerCluster#logging_service}
     *
     * @stability stable
     */
    readonly loggingService?: string;
    /**
     * The minimum version of the master.
     *
     * GKE will auto-update the master to new versions, so this does not guarantee the current master version--use the read-only master_version field to obtain that. If unset, the cluster's version will be set by GKE to the version of the most recent official release (which is not necessarily the latest version).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#min_master_version ContainerCluster#min_master_version}
     *
     * @stability stable
     */
    readonly minMasterVersion?: string;
    /**
     * The monitoring service that the cluster should write metrics to.
     *
     * Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API. VM metrics will be collected by Google Compute Engine regardless of this setting Available options include monitoring.googleapis.com(Legacy Stackdriver), monitoring.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Monitoring), and none. Defaults to monitoring.googleapis.com/kubernetes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#monitoring_service ContainerCluster#monitoring_service}
     *
     * @stability stable
     */
    readonly monitoringService?: string;
    /**
     * The name of the cluster, unique within the project and location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#name ContainerCluster#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The name or self_link of the Google Compute Engine network to which the cluster is connected.
     *
     * For Shared VPC, set this to the self link of the shared network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#network ContainerCluster#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * Determines whether alias IPs or routes will be used for pod IPs in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#networking_mode ContainerCluster#networking_mode}
     *
     * @stability stable
     */
    readonly networkingMode?: string;
    /**
     * The list of zones in which the cluster's nodes are located.
     *
     * Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If this is specified for a zonal cluster, omit the cluster's zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_locations ContainerCluster#node_locations}
     *
     * @stability stable
     */
    readonly nodeLocations?: string[];
    /**
     * The Kubernetes version on the nodes.
     *
     * Must either be unset or set to the same value as min_master_version on create. Defaults to the default version set by GKE which is not necessarily the latest version. This only affects nodes in the default node pool. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way. To update nodes in other node pools, use the version attribute on the node pool.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_version ContainerCluster#node_version}
     *
     * @stability stable
     */
    readonly nodeVersion?: string;
    /**
     * The desired state of IPv6 connectivity to Google Services.
     *
     * By default, no private IPv6 access to or from Google Services (all access will be via IPv4).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#private_ipv6_google_access ContainerCluster#private_ipv6_google_access}
     *
     * @stability stable
     */
    readonly privateIpv6GoogleAccess?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#project ContainerCluster#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * If true, deletes the default node pool upon cluster creation.
     *
     * If you're using google_container_node_pool resources with no default node pool, this should be set to true, alongside setting initial_node_count to at least 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#remove_default_node_pool ContainerCluster#remove_default_node_pool}
     *
     * @stability stable
     */
    readonly removeDefaultNodePool?: boolean;
    /**
     * The GCE resource labels (a map of key/value pairs) to be applied to the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#resource_labels ContainerCluster#resource_labels}
     *
     * @stability stable
     */
    readonly resourceLabels?: {
        [key: string]: string;
    };
    /**
     * The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#subnetwork ContainerCluster#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * addons_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#addons_config ContainerCluster#addons_config}
     *
     * @stability stable
     */
    readonly addonsConfig?: ContainerClusterAddonsConfig[];
    /**
     * authenticator_groups_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#authenticator_groups_config ContainerCluster#authenticator_groups_config}
     *
     * @stability stable
     */
    readonly authenticatorGroupsConfig?: ContainerClusterAuthenticatorGroupsConfig[];
    /**
     * cluster_autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cluster_autoscaling ContainerCluster#cluster_autoscaling}
     *
     * @stability stable
     */
    readonly clusterAutoscaling?: ContainerClusterClusterAutoscaling[];
    /**
     * database_encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#database_encryption ContainerCluster#database_encryption}
     *
     * @stability stable
     */
    readonly databaseEncryption?: ContainerClusterDatabaseEncryption[];
    /**
     * default_snat_status block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#default_snat_status ContainerCluster#default_snat_status}
     *
     * @stability stable
     */
    readonly defaultSnatStatus?: ContainerClusterDefaultSnatStatus[];
    /**
     * ip_allocation_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#ip_allocation_policy ContainerCluster#ip_allocation_policy}
     *
     * @stability stable
     */
    readonly ipAllocationPolicy?: ContainerClusterIpAllocationPolicy[];
    /**
     * maintenance_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#maintenance_policy ContainerCluster#maintenance_policy}
     *
     * @stability stable
     */
    readonly maintenancePolicy?: ContainerClusterMaintenancePolicy[];
    /**
     * master_auth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#master_auth ContainerCluster#master_auth}
     *
     * @stability stable
     */
    readonly masterAuth?: ContainerClusterMasterAuth[];
    /**
     * master_authorized_networks_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#master_authorized_networks_config ContainerCluster#master_authorized_networks_config}
     *
     * @stability stable
     */
    readonly masterAuthorizedNetworksConfig?: ContainerClusterMasterAuthorizedNetworksConfig[];
    /**
     * network_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#network_policy ContainerCluster#network_policy}
     *
     * @stability stable
     */
    readonly networkPolicy?: ContainerClusterNetworkPolicy[];
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_config ContainerCluster#node_config}
     *
     * @stability stable
     */
    readonly nodeConfig?: ContainerClusterNodeConfig[];
    /**
     * node_pool block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_pool ContainerCluster#node_pool}
     *
     * @stability stable
     */
    readonly nodePool?: ContainerClusterNodePool[];
    /**
     * pod_security_policy_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#pod_security_policy_config ContainerCluster#pod_security_policy_config}
     *
     * @stability stable
     */
    readonly podSecurityPolicyConfig?: ContainerClusterPodSecurityPolicyConfig[];
    /**
     * private_cluster_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#private_cluster_config ContainerCluster#private_cluster_config}
     *
     * @stability stable
     */
    readonly privateClusterConfig?: ContainerClusterPrivateClusterConfig[];
    /**
     * release_channel block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#release_channel ContainerCluster#release_channel}
     *
     * @stability stable
     */
    readonly releaseChannel?: ContainerClusterReleaseChannel[];
    /**
     * resource_usage_export_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#resource_usage_export_config ContainerCluster#resource_usage_export_config}
     *
     * @stability stable
     */
    readonly resourceUsageExportConfig?: ContainerClusterResourceUsageExportConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#timeouts ContainerCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ContainerClusterTimeouts;
    /**
     * vertical_pod_autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#vertical_pod_autoscaling ContainerCluster#vertical_pod_autoscaling}
     *
     * @stability stable
     */
    readonly verticalPodAutoscaling?: ContainerClusterVerticalPodAutoscaling[];
    /**
     * workload_identity_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#workload_identity_config ContainerCluster#workload_identity_config}
     *
     * @stability stable
     */
    readonly workloadIdentityConfig?: ContainerClusterWorkloadIdentityConfig[];
}
/**
 * @stability stable
 */
export interface ContainerClusterAddonsConfigCloudrunConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disabled ContainerCluster#disabled}.
     *
     * @stability stable
     */
    readonly disabled: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#load_balancer_type ContainerCluster#load_balancer_type}.
     *
     * @stability stable
     */
    readonly loadBalancerType?: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterAddonsConfigHorizontalPodAutoscaling {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disabled ContainerCluster#disabled}.
     *
     * @stability stable
     */
    readonly disabled: boolean;
}
/**
 * @stability stable
 */
export interface ContainerClusterAddonsConfigHttpLoadBalancing {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disabled ContainerCluster#disabled}.
     *
     * @stability stable
     */
    readonly disabled: boolean;
}
/**
 * @stability stable
 */
export interface ContainerClusterAddonsConfigNetworkPolicyConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disabled ContainerCluster#disabled}.
     *
     * @stability stable
     */
    readonly disabled: boolean;
}
/**
 * @stability stable
 */
export interface ContainerClusterAddonsConfig {
    /**
     * cloudrun_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cloudrun_config ContainerCluster#cloudrun_config}
     *
     * @stability stable
     */
    readonly cloudrunConfig?: ContainerClusterAddonsConfigCloudrunConfig[];
    /**
     * horizontal_pod_autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#horizontal_pod_autoscaling ContainerCluster#horizontal_pod_autoscaling}
     *
     * @stability stable
     */
    readonly horizontalPodAutoscaling?: ContainerClusterAddonsConfigHorizontalPodAutoscaling[];
    /**
     * http_load_balancing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#http_load_balancing ContainerCluster#http_load_balancing}
     *
     * @stability stable
     */
    readonly httpLoadBalancing?: ContainerClusterAddonsConfigHttpLoadBalancing[];
    /**
     * network_policy_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#network_policy_config ContainerCluster#network_policy_config}
     *
     * @stability stable
     */
    readonly networkPolicyConfig?: ContainerClusterAddonsConfigNetworkPolicyConfig[];
}
/**
 * @stability stable
 */
export interface ContainerClusterAuthenticatorGroupsConfig {
    /**
     * The name of the RBAC security group for use with Google security groups in Kubernetes RBAC.
     *
     * Group name must be in format gke-security-groups@yourdomain.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#security_group ContainerCluster#security_group}
     *
     * @stability stable
     */
    readonly securityGroup: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterClusterAutoscalingAutoProvisioningDefaults {
    /**
     * Scopes that are used by NAP when creating node pools.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#oauth_scopes ContainerCluster#oauth_scopes}
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#service_account ContainerCluster#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterClusterAutoscalingResourceLimits {
    /**
     * Maximum amount of the resource in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#maximum ContainerCluster#maximum}
     *
     * @stability stable
     */
    readonly maximum?: number;
    /**
     * Minimum amount of the resource in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#minimum ContainerCluster#minimum}
     *
     * @stability stable
     */
    readonly minimum?: number;
    /**
     * The type of the resource.
     *
     * For example, cpu and memory. See the guide to using Node Auto-Provisioning for a list of types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#resource_type ContainerCluster#resource_type}
     *
     * @stability stable
     */
    readonly resourceType: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterClusterAutoscaling {
    /**
     * Whether node auto-provisioning is enabled. Resource limits for cpu and memory must be defined to enable node auto-provisioning.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enabled ContainerCluster#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean;
    /**
     * auto_provisioning_defaults block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#auto_provisioning_defaults ContainerCluster#auto_provisioning_defaults}
     *
     * @stability stable
     */
    readonly autoProvisioningDefaults?: ContainerClusterClusterAutoscalingAutoProvisioningDefaults[];
    /**
     * resource_limits block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#resource_limits ContainerCluster#resource_limits}
     *
     * @stability stable
     */
    readonly resourceLimits?: ContainerClusterClusterAutoscalingResourceLimits[];
}
/**
 * @stability stable
 */
export interface ContainerClusterDatabaseEncryption {
    /**
     * The key to use to encrypt/decrypt secrets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#key_name ContainerCluster#key_name}
     *
     * @stability stable
     */
    readonly keyName?: string;
    /**
     * ENCRYPTED or DECRYPTED.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#state ContainerCluster#state}
     *
     * @stability stable
     */
    readonly state: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterDefaultSnatStatus {
    /**
     * When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disabled ContainerCluster#disabled}
     *
     * @stability stable
     */
    readonly disabled: boolean;
}
/**
 * @stability stable
 */
export interface ContainerClusterIpAllocationPolicy {
    /**
     * The IP address range for the cluster pod IPs.
     *
     * Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cluster_ipv4_cidr_block ContainerCluster#cluster_ipv4_cidr_block}
     *
     * @stability stable
     */
    readonly clusterIpv4CidrBlock?: string;
    /**
     * The name of the existing secondary range in the cluster's subnetwork to use for pod IP addresses.
     *
     * Alternatively, cluster_ipv4_cidr_block can be used to automatically create a GKE-managed one.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cluster_secondary_range_name ContainerCluster#cluster_secondary_range_name}
     *
     * @stability stable
     */
    readonly clusterSecondaryRangeName?: string;
    /**
     * The IP address range of the services IPs in this cluster.
     *
     * Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#services_ipv4_cidr_block ContainerCluster#services_ipv4_cidr_block}
     *
     * @stability stable
     */
    readonly servicesIpv4CidrBlock?: string;
    /**
     * The name of the existing secondary range in the cluster's subnetwork to use for service ClusterIPs.
     *
     * Alternatively, services_ipv4_cidr_block can be used to automatically create a GKE-managed one.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#services_secondary_range_name ContainerCluster#services_secondary_range_name}
     *
     * @stability stable
     */
    readonly servicesSecondaryRangeName?: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterMaintenancePolicyDailyMaintenanceWindow {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#start_time ContainerCluster#start_time}.
     *
     * @stability stable
     */
    readonly startTime: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterMaintenancePolicyMaintenanceExclusion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#end_time ContainerCluster#end_time}.
     *
     * @stability stable
     */
    readonly endTime: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#exclusion_name ContainerCluster#exclusion_name}.
     *
     * @stability stable
     */
    readonly exclusionName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#start_time ContainerCluster#start_time}.
     *
     * @stability stable
     */
    readonly startTime: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterMaintenancePolicyRecurringWindow {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#end_time ContainerCluster#end_time}.
     *
     * @stability stable
     */
    readonly endTime: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#recurrence ContainerCluster#recurrence}.
     *
     * @stability stable
     */
    readonly recurrence: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#start_time ContainerCluster#start_time}.
     *
     * @stability stable
     */
    readonly startTime: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterMaintenancePolicy {
    /**
     * daily_maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#daily_maintenance_window ContainerCluster#daily_maintenance_window}
     *
     * @stability stable
     */
    readonly dailyMaintenanceWindow?: ContainerClusterMaintenancePolicyDailyMaintenanceWindow[];
    /**
     * maintenance_exclusion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#maintenance_exclusion ContainerCluster#maintenance_exclusion}
     *
     * @stability stable
     */
    readonly maintenanceExclusion?: ContainerClusterMaintenancePolicyMaintenanceExclusion[];
    /**
     * recurring_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#recurring_window ContainerCluster#recurring_window}
     *
     * @stability stable
     */
    readonly recurringWindow?: ContainerClusterMaintenancePolicyRecurringWindow[];
}
/**
 * @stability stable
 */
export interface ContainerClusterMasterAuthClientCertificateConfig {
    /**
     * Whether client certificate authorization is enabled for this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#issue_client_certificate ContainerCluster#issue_client_certificate}
     *
     * @stability stable
     */
    readonly issueClientCertificate: boolean;
}
/**
 * @stability stable
 */
export interface ContainerClusterMasterAuth {
    /**
     * The password to use for HTTP basic authentication when accessing the Kubernetes master endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#password ContainerCluster#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * The username to use for HTTP basic authentication when accessing the Kubernetes master endpoint.
     *
     * If not present basic auth will be disabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#username ContainerCluster#username}
     *
     * @stability stable
     */
    readonly username?: string;
    /**
     * client_certificate_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#client_certificate_config ContainerCluster#client_certificate_config}
     *
     * @stability stable
     */
    readonly clientCertificateConfig?: ContainerClusterMasterAuthClientCertificateConfig[];
}
/**
 * @stability stable
 */
export interface ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks {
    /**
     * External network that can access Kubernetes master through HTTPS. Must be specified in CIDR notation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cidr_block ContainerCluster#cidr_block}
     *
     * @stability stable
     */
    readonly cidrBlock: string;
    /**
     * Field for users to identify CIDR blocks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#display_name ContainerCluster#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterMasterAuthorizedNetworksConfig {
    /**
     * cidr_blocks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cidr_blocks ContainerCluster#cidr_blocks}
     *
     * @stability stable
     */
    readonly cidrBlocks?: ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[];
}
/**
 * @stability stable
 */
export interface ContainerClusterNetworkPolicy {
    /**
     * Whether network policy is enabled on the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enabled ContainerCluster#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean;
    /**
     * The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#provider ContainerCluster#provider}
     *
     * @stability stable
     */
    readonly provider?: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodeConfigGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#count ContainerCluster#count}.
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#type ContainerCluster#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodeConfigTaint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#effect ContainerCluster#effect}.
     *
     * @stability stable
     */
    readonly effect?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#key ContainerCluster#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#value ContainerCluster#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodeConfigShieldedInstanceConfig {
    /**
     * Defines whether the instance has integrity monitoring enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_integrity_monitoring ContainerCluster#enable_integrity_monitoring}
     *
     * @stability stable
     */
    readonly enableIntegrityMonitoring?: boolean;
    /**
     * Defines whether the instance has Secure Boot enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_secure_boot ContainerCluster#enable_secure_boot}
     *
     * @stability stable
     */
    readonly enableSecureBoot?: boolean;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodeConfigWorkloadMetadataConfig {
    /**
     * NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_metadata ContainerCluster#node_metadata}
     *
     * @stability stable
     */
    readonly nodeMetadata: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodeConfig {
    /**
     * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disk_size_gb ContainerCluster#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Type of the disk attached to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disk_type ContainerCluster#disk_type}
     *
     * @stability stable
     */
    readonly diskType?: string;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#guest_accelerator ContainerCluster#guest_accelerator}
     *
     * @stability stable
     */
    readonly guestAccelerator?: ContainerClusterNodeConfigGuestAccelerator[];
    /**
     * The image type to use for this node.
     *
     * Note that for a given image type, the latest version of it will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#image_type ContainerCluster#image_type}
     *
     * @stability stable
     */
    readonly imageType?: string;
    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     *
     * These will added in addition to any default label(s) that Kubernetes may apply to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#labels ContainerCluster#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The number of local SSD disks to be attached to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#local_ssd_count ContainerCluster#local_ssd_count}
     *
     * @stability stable
     */
    readonly localSsdCount?: number;
    /**
     * The name of a Google Compute Engine machine type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#machine_type ContainerCluster#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#metadata ContainerCluster#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
     * Minimum CPU platform to be used by this instance.
     *
     * The instance may be scheduled on the specified or newer CPU platform.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#min_cpu_platform ContainerCluster#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * The set of Google API scopes to be made available on all of the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#oauth_scopes ContainerCluster#oauth_scopes}
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
    /**
     * Whether the nodes are created as preemptible VM instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#preemptible ContainerCluster#preemptible}
     *
     * @stability stable
     */
    readonly preemptible?: boolean;
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#service_account ContainerCluster#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * The list of instance tags applied to all nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#tags ContainerCluster#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * List of Kubernetes taints to be applied to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#taint ContainerCluster#taint}
     *
     * @stability stable
     */
    readonly taint?: ContainerClusterNodeConfigTaint[];
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#shielded_instance_config ContainerCluster#shielded_instance_config}
     *
     * @stability stable
     */
    readonly shieldedInstanceConfig?: ContainerClusterNodeConfigShieldedInstanceConfig[];
    /**
     * workload_metadata_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#workload_metadata_config ContainerCluster#workload_metadata_config}
     *
     * @stability stable
     */
    readonly workloadMetadataConfig?: ContainerClusterNodeConfigWorkloadMetadataConfig[];
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolAutoscaling {
    /**
     * Maximum number of nodes in the NodePool. Must be >= min_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#max_node_count ContainerCluster#max_node_count}
     *
     * @stability stable
     */
    readonly maxNodeCount: number;
    /**
     * Minimum number of nodes in the NodePool. Must be >=0 and <= max_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#min_node_count ContainerCluster#min_node_count}
     *
     * @stability stable
     */
    readonly minNodeCount: number;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolManagement {
    /**
     * Whether the nodes will be automatically repaired.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#auto_repair ContainerCluster#auto_repair}
     *
     * @stability stable
     */
    readonly autoRepair?: boolean;
    /**
     * Whether the nodes will be automatically upgraded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#auto_upgrade ContainerCluster#auto_upgrade}
     *
     * @stability stable
     */
    readonly autoUpgrade?: boolean;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolNodeConfigGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#count ContainerCluster#count}.
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#type ContainerCluster#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolNodeConfigTaint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#effect ContainerCluster#effect}.
     *
     * @stability stable
     */
    readonly effect?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#key ContainerCluster#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#value ContainerCluster#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolNodeConfigShieldedInstanceConfig {
    /**
     * Defines whether the instance has integrity monitoring enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_integrity_monitoring ContainerCluster#enable_integrity_monitoring}
     *
     * @stability stable
     */
    readonly enableIntegrityMonitoring?: boolean;
    /**
     * Defines whether the instance has Secure Boot enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_secure_boot ContainerCluster#enable_secure_boot}
     *
     * @stability stable
     */
    readonly enableSecureBoot?: boolean;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig {
    /**
     * NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_metadata ContainerCluster#node_metadata}
     *
     * @stability stable
     */
    readonly nodeMetadata: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolNodeConfig {
    /**
     * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disk_size_gb ContainerCluster#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Type of the disk attached to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disk_type ContainerCluster#disk_type}
     *
     * @stability stable
     */
    readonly diskType?: string;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#guest_accelerator ContainerCluster#guest_accelerator}
     *
     * @stability stable
     */
    readonly guestAccelerator?: ContainerClusterNodePoolNodeConfigGuestAccelerator[];
    /**
     * The image type to use for this node.
     *
     * Note that for a given image type, the latest version of it will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#image_type ContainerCluster#image_type}
     *
     * @stability stable
     */
    readonly imageType?: string;
    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     *
     * These will added in addition to any default label(s) that Kubernetes may apply to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#labels ContainerCluster#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The number of local SSD disks to be attached to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#local_ssd_count ContainerCluster#local_ssd_count}
     *
     * @stability stable
     */
    readonly localSsdCount?: number;
    /**
     * The name of a Google Compute Engine machine type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#machine_type ContainerCluster#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#metadata ContainerCluster#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
     * Minimum CPU platform to be used by this instance.
     *
     * The instance may be scheduled on the specified or newer CPU platform.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#min_cpu_platform ContainerCluster#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * The set of Google API scopes to be made available on all of the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#oauth_scopes ContainerCluster#oauth_scopes}
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
    /**
     * Whether the nodes are created as preemptible VM instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#preemptible ContainerCluster#preemptible}
     *
     * @stability stable
     */
    readonly preemptible?: boolean;
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#service_account ContainerCluster#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * The list of instance tags applied to all nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#tags ContainerCluster#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * List of Kubernetes taints to be applied to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#taint ContainerCluster#taint}
     *
     * @stability stable
     */
    readonly taint?: ContainerClusterNodePoolNodeConfigTaint[];
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#shielded_instance_config ContainerCluster#shielded_instance_config}
     *
     * @stability stable
     */
    readonly shieldedInstanceConfig?: ContainerClusterNodePoolNodeConfigShieldedInstanceConfig[];
    /**
     * workload_metadata_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#workload_metadata_config ContainerCluster#workload_metadata_config}
     *
     * @stability stable
     */
    readonly workloadMetadataConfig?: ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig[];
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolUpgradeSettings {
    /**
     * The number of additional nodes that can be added to the node pool during an upgrade.
     *
     * Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#max_surge ContainerCluster#max_surge}
     *
     * @stability stable
     */
    readonly maxSurge: number;
    /**
     * The number of nodes that can be simultaneously unavailable during an upgrade.
     *
     * Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#max_unavailable ContainerCluster#max_unavailable}
     *
     * @stability stable
     */
    readonly maxUnavailable: number;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePool {
    /**
     * The initial number of nodes for the pool.
     *
     * In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#initial_node_count ContainerCluster#initial_node_count}
     *
     * @stability stable
     */
    readonly initialNodeCount?: number;
    /**
     * The maximum number of pods per node in this node pool.
     *
     * Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#max_pods_per_node ContainerCluster#max_pods_per_node}
     *
     * @stability stable
     */
    readonly maxPodsPerNode?: number;
    /**
     * The name of the node pool. If left blank, Terraform will auto-generate a unique name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#name ContainerCluster#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#name_prefix ContainerCluster#name_prefix}
     *
     * @stability stable
     */
    readonly namePrefix?: string;
    /**
     * The number of nodes per instance group.
     *
     * This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_count ContainerCluster#node_count}
     *
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * The list of zones in which the node pool's nodes should be located.
     *
     * Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_locations ContainerCluster#node_locations}
     *
     * @stability stable
     */
    readonly nodeLocations?: string[];
    /**
     * The Kubernetes version for the nodes in this pool.
     *
     * Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#version ContainerCluster#version}
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#autoscaling ContainerCluster#autoscaling}
     *
     * @stability stable
     */
    readonly autoscaling?: ContainerClusterNodePoolAutoscaling[];
    /**
     * management block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#management ContainerCluster#management}
     *
     * @stability stable
     */
    readonly management?: ContainerClusterNodePoolManagement[];
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_config ContainerCluster#node_config}
     *
     * @stability stable
     */
    readonly nodeConfig?: ContainerClusterNodePoolNodeConfig[];
    /**
     * upgrade_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#upgrade_settings ContainerCluster#upgrade_settings}
     *
     * @stability stable
     */
    readonly upgradeSettings?: ContainerClusterNodePoolUpgradeSettings[];
}
/**
 * @stability stable
 */
export interface ContainerClusterPodSecurityPolicyConfig {
    /**
     * Enable the PodSecurityPolicy controller for this cluster. If enabled, pods must be valid under a PodSecurityPolicy to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enabled ContainerCluster#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean;
}
/**
 * @stability stable
 */
export interface ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig {
    /**
     * Whether the cluster master is accessible globally or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enabled ContainerCluster#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean;
}
/**
 * @stability stable
 */
export interface ContainerClusterPrivateClusterConfig {
    /**
     * Enables the private cluster feature, creating a private endpoint on the cluster.
     *
     * In a private cluster, nodes only have RFC 1918 private addresses and communicate with the master's private endpoint via private networking.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_private_endpoint ContainerCluster#enable_private_endpoint}
     *
     * @stability stable
     */
    readonly enablePrivateEndpoint: boolean;
    /**
     * When true, the cluster's private endpoint is used as the cluster endpoint and access through the public endpoint is disabled.
     *
     * When false, either endpoint can be used. This field only applies to private clusters, when enable_private_nodes is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_private_nodes ContainerCluster#enable_private_nodes}
     *
     * @stability stable
     */
    readonly enablePrivateNodes?: boolean;
    /**
     * The IP range in CIDR notation to use for the hosted master network.
     *
     * This range will be used for assigning private IP addresses to the cluster master(s) and the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network, and it must be a /28 subnet. See Private Cluster Limitations for more details. This field only applies to private clusters, when enable_private_nodes is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#master_ipv4_cidr_block ContainerCluster#master_ipv4_cidr_block}
     *
     * @stability stable
     */
    readonly masterIpv4CidrBlock?: string;
    /**
     * master_global_access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#master_global_access_config ContainerCluster#master_global_access_config}
     *
     * @stability stable
     */
    readonly masterGlobalAccessConfig?: ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig[];
}
/**
 * @stability stable
 */
export interface ContainerClusterReleaseChannel {
    /**
     * The selected release channel.
     *
     * Accepted values are:
     * UNSPECIFIED: Not set.
     * RAPID: Weekly upgrade cadence; Early testers and developers who requires new features.
     * REGULAR: Multiple per month upgrade cadence; Production users who need features not yet offered in the Stable channel.
     * STABLE: Every few months upgrade cadence; Production users who need stability above all else, and for whom frequent upgrades are too risky.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#channel ContainerCluster#channel}
     *
     * @stability stable
     */
    readonly channel: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterResourceUsageExportConfigBigqueryDestination {
    /**
     * The ID of a BigQuery Dataset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#dataset_id ContainerCluster#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterResourceUsageExportConfig {
    /**
     * Whether to enable network egress metering for this cluster.
     *
     * If enabled, a daemonset will be created in the cluster to meter network egress traffic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_network_egress_metering ContainerCluster#enable_network_egress_metering}
     *
     * @stability stable
     */
    readonly enableNetworkEgressMetering?: boolean;
    /**
     * Whether to enable resource consumption metering on this cluster.
     *
     * When enabled, a table will be created in the resource export BigQuery dataset to store resource consumption data. The resulting table can be joined with the resource usage table or with BigQuery billing export. Defaults to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_resource_consumption_metering ContainerCluster#enable_resource_consumption_metering}
     *
     * @stability stable
     */
    readonly enableResourceConsumptionMetering?: boolean;
    /**
     * bigquery_destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#bigquery_destination ContainerCluster#bigquery_destination}
     *
     * @stability stable
     */
    readonly bigqueryDestination: ContainerClusterResourceUsageExportConfigBigqueryDestination[];
}
/**
 * @stability stable
 */
export interface ContainerClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#create ContainerCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#delete ContainerCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#read ContainerCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#update ContainerCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export interface ContainerClusterVerticalPodAutoscaling {
    /**
     * Enables vertical pod autoscaling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enabled ContainerCluster#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean;
}
/**
 * @stability stable
 */
export interface ContainerClusterWorkloadIdentityConfig {
    /**
     * Enables workload identity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#identity_namespace ContainerCluster#identity_namespace}
     *
     * @stability stable
     */
    readonly identityNamespace: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html google_container_cluster}.
 *
 * @stability stable
 */
export declare class ContainerCluster extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html google_container_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ContainerClusterConfig);
    private _clusterIpv4Cidr?;
    /**
     * @stability stable
     */
    get clusterIpv4Cidr(): string;
    /**
     * @stability stable
     */
    set clusterIpv4Cidr(value: string);
    /**
     * @stability stable
     */
    resetClusterIpv4Cidr(): void;
    /**
     * @stability stable
     */
    get clusterIpv4CidrInput(): string | undefined;
    private _datapathProvider?;
    /**
     * @stability stable
     */
    get datapathProvider(): string;
    /**
     * @stability stable
     */
    set datapathProvider(value: string);
    /**
     * @stability stable
     */
    resetDatapathProvider(): void;
    /**
     * @stability stable
     */
    get datapathProviderInput(): string | undefined;
    private _defaultMaxPodsPerNode?;
    /**
     * @stability stable
     */
    get defaultMaxPodsPerNode(): number;
    /**
     * @stability stable
     */
    set defaultMaxPodsPerNode(value: number);
    /**
     * @stability stable
     */
    resetDefaultMaxPodsPerNode(): void;
    /**
     * @stability stable
     */
    get defaultMaxPodsPerNodeInput(): number | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableAutopilot?;
    /**
     * @stability stable
     */
    get enableAutopilot(): boolean;
    /**
     * @stability stable
     */
    set enableAutopilot(value: boolean);
    /**
     * @stability stable
     */
    resetEnableAutopilot(): void;
    /**
     * @stability stable
     */
    get enableAutopilotInput(): boolean | undefined;
    private _enableBinaryAuthorization?;
    /**
     * @stability stable
     */
    get enableBinaryAuthorization(): boolean;
    /**
     * @stability stable
     */
    set enableBinaryAuthorization(value: boolean);
    /**
     * @stability stable
     */
    resetEnableBinaryAuthorization(): void;
    /**
     * @stability stable
     */
    get enableBinaryAuthorizationInput(): boolean | undefined;
    private _enableIntranodeVisibility?;
    /**
     * @stability stable
     */
    get enableIntranodeVisibility(): boolean;
    /**
     * @stability stable
     */
    set enableIntranodeVisibility(value: boolean);
    /**
     * @stability stable
     */
    resetEnableIntranodeVisibility(): void;
    /**
     * @stability stable
     */
    get enableIntranodeVisibilityInput(): boolean | undefined;
    private _enableKubernetesAlpha?;
    /**
     * @stability stable
     */
    get enableKubernetesAlpha(): boolean;
    /**
     * @stability stable
     */
    set enableKubernetesAlpha(value: boolean);
    /**
     * @stability stable
     */
    resetEnableKubernetesAlpha(): void;
    /**
     * @stability stable
     */
    get enableKubernetesAlphaInput(): boolean | undefined;
    private _enableLegacyAbac?;
    /**
     * @stability stable
     */
    get enableLegacyAbac(): boolean;
    /**
     * @stability stable
     */
    set enableLegacyAbac(value: boolean);
    /**
     * @stability stable
     */
    resetEnableLegacyAbac(): void;
    /**
     * @stability stable
     */
    get enableLegacyAbacInput(): boolean | undefined;
    private _enableShieldedNodes?;
    /**
     * @stability stable
     */
    get enableShieldedNodes(): boolean;
    /**
     * @stability stable
     */
    set enableShieldedNodes(value: boolean);
    /**
     * @stability stable
     */
    resetEnableShieldedNodes(): void;
    /**
     * @stability stable
     */
    get enableShieldedNodesInput(): boolean | undefined;
    private _enableTpu?;
    /**
     * @stability stable
     */
    get enableTpu(): boolean;
    /**
     * @stability stable
     */
    set enableTpu(value: boolean);
    /**
     * @stability stable
     */
    resetEnableTpu(): void;
    /**
     * @stability stable
     */
    get enableTpuInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _initialNodeCount?;
    /**
     * @stability stable
     */
    get initialNodeCount(): number;
    /**
     * @stability stable
     */
    set initialNodeCount(value: number);
    /**
     * @stability stable
     */
    resetInitialNodeCount(): void;
    /**
     * @stability stable
     */
    get initialNodeCountInput(): number | undefined;
    /**
     * @stability stable
     */
    get instanceGroupUrls(): string[];
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _loggingService?;
    /**
     * @stability stable
     */
    get loggingService(): string;
    /**
     * @stability stable
     */
    set loggingService(value: string);
    /**
     * @stability stable
     */
    resetLoggingService(): void;
    /**
     * @stability stable
     */
    get loggingServiceInput(): string | undefined;
    /**
     * @stability stable
     */
    get masterVersion(): string;
    private _minMasterVersion?;
    /**
     * @stability stable
     */
    get minMasterVersion(): string;
    /**
     * @stability stable
     */
    set minMasterVersion(value: string);
    /**
     * @stability stable
     */
    resetMinMasterVersion(): void;
    /**
     * @stability stable
     */
    get minMasterVersionInput(): string | undefined;
    private _monitoringService?;
    /**
     * @stability stable
     */
    get monitoringService(): string;
    /**
     * @stability stable
     */
    set monitoringService(value: string);
    /**
     * @stability stable
     */
    resetMonitoringService(): void;
    /**
     * @stability stable
     */
    get monitoringServiceInput(): string | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _networkingMode?;
    /**
     * @stability stable
     */
    get networkingMode(): string;
    /**
     * @stability stable
     */
    set networkingMode(value: string);
    /**
     * @stability stable
     */
    resetNetworkingMode(): void;
    /**
     * @stability stable
     */
    get networkingModeInput(): string | undefined;
    private _nodeLocations?;
    /**
     * @stability stable
     */
    get nodeLocations(): string[];
    /**
     * @stability stable
     */
    set nodeLocations(value: string[]);
    /**
     * @stability stable
     */
    resetNodeLocations(): void;
    /**
     * @stability stable
     */
    get nodeLocationsInput(): string[] | undefined;
    private _nodeVersion?;
    /**
     * @stability stable
     */
    get nodeVersion(): string;
    /**
     * @stability stable
     */
    set nodeVersion(value: string);
    /**
     * @stability stable
     */
    resetNodeVersion(): void;
    /**
     * @stability stable
     */
    get nodeVersionInput(): string | undefined;
    /**
     * @stability stable
     */
    get operation(): string;
    private _privateIpv6GoogleAccess?;
    /**
     * @stability stable
     */
    get privateIpv6GoogleAccess(): string;
    /**
     * @stability stable
     */
    set privateIpv6GoogleAccess(value: string);
    /**
     * @stability stable
     */
    resetPrivateIpv6GoogleAccess(): void;
    /**
     * @stability stable
     */
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _removeDefaultNodePool?;
    /**
     * @stability stable
     */
    get removeDefaultNodePool(): boolean;
    /**
     * @stability stable
     */
    set removeDefaultNodePool(value: boolean);
    /**
     * @stability stable
     */
    resetRemoveDefaultNodePool(): void;
    /**
     * @stability stable
     */
    get removeDefaultNodePoolInput(): boolean | undefined;
    private _resourceLabels?;
    /**
     * @stability stable
     */
    get resourceLabels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set resourceLabels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetResourceLabels(): void;
    /**
     * @stability stable
     */
    get resourceLabelsInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get servicesIpv4Cidr(): string;
    private _subnetwork?;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    set subnetwork(value: string);
    /**
     * @stability stable
     */
    resetSubnetwork(): void;
    /**
     * @stability stable
     */
    get subnetworkInput(): string | undefined;
    /**
     * @stability stable
     */
    get tpuIpv4CidrBlock(): string;
    private _addonsConfig?;
    /**
     * @stability stable
     */
    get addonsConfig(): ContainerClusterAddonsConfig[];
    /**
     * @stability stable
     */
    set addonsConfig(value: ContainerClusterAddonsConfig[]);
    /**
     * @stability stable
     */
    resetAddonsConfig(): void;
    /**
     * @stability stable
     */
    get addonsConfigInput(): ContainerClusterAddonsConfig[] | undefined;
    private _authenticatorGroupsConfig?;
    /**
     * @stability stable
     */
    get authenticatorGroupsConfig(): ContainerClusterAuthenticatorGroupsConfig[];
    /**
     * @stability stable
     */
    set authenticatorGroupsConfig(value: ContainerClusterAuthenticatorGroupsConfig[]);
    /**
     * @stability stable
     */
    resetAuthenticatorGroupsConfig(): void;
    /**
     * @stability stable
     */
    get authenticatorGroupsConfigInput(): ContainerClusterAuthenticatorGroupsConfig[] | undefined;
    private _clusterAutoscaling?;
    /**
     * @stability stable
     */
    get clusterAutoscaling(): ContainerClusterClusterAutoscaling[];
    /**
     * @stability stable
     */
    set clusterAutoscaling(value: ContainerClusterClusterAutoscaling[]);
    /**
     * @stability stable
     */
    resetClusterAutoscaling(): void;
    /**
     * @stability stable
     */
    get clusterAutoscalingInput(): ContainerClusterClusterAutoscaling[] | undefined;
    private _databaseEncryption?;
    /**
     * @stability stable
     */
    get databaseEncryption(): ContainerClusterDatabaseEncryption[];
    /**
     * @stability stable
     */
    set databaseEncryption(value: ContainerClusterDatabaseEncryption[]);
    /**
     * @stability stable
     */
    resetDatabaseEncryption(): void;
    /**
     * @stability stable
     */
    get databaseEncryptionInput(): ContainerClusterDatabaseEncryption[] | undefined;
    private _defaultSnatStatus?;
    /**
     * @stability stable
     */
    get defaultSnatStatus(): ContainerClusterDefaultSnatStatus[];
    /**
     * @stability stable
     */
    set defaultSnatStatus(value: ContainerClusterDefaultSnatStatus[]);
    /**
     * @stability stable
     */
    resetDefaultSnatStatus(): void;
    /**
     * @stability stable
     */
    get defaultSnatStatusInput(): ContainerClusterDefaultSnatStatus[] | undefined;
    private _ipAllocationPolicy?;
    /**
     * @stability stable
     */
    get ipAllocationPolicy(): ContainerClusterIpAllocationPolicy[];
    /**
     * @stability stable
     */
    set ipAllocationPolicy(value: ContainerClusterIpAllocationPolicy[]);
    /**
     * @stability stable
     */
    resetIpAllocationPolicy(): void;
    /**
     * @stability stable
     */
    get ipAllocationPolicyInput(): ContainerClusterIpAllocationPolicy[] | undefined;
    private _maintenancePolicy?;
    /**
     * @stability stable
     */
    get maintenancePolicy(): ContainerClusterMaintenancePolicy[];
    /**
     * @stability stable
     */
    set maintenancePolicy(value: ContainerClusterMaintenancePolicy[]);
    /**
     * @stability stable
     */
    resetMaintenancePolicy(): void;
    /**
     * @stability stable
     */
    get maintenancePolicyInput(): ContainerClusterMaintenancePolicy[] | undefined;
    private _masterAuth?;
    /**
     * @stability stable
     */
    get masterAuth(): ContainerClusterMasterAuth[];
    /**
     * @stability stable
     */
    set masterAuth(value: ContainerClusterMasterAuth[]);
    /**
     * @stability stable
     */
    resetMasterAuth(): void;
    /**
     * @stability stable
     */
    get masterAuthInput(): ContainerClusterMasterAuth[] | undefined;
    private _masterAuthorizedNetworksConfig?;
    /**
     * @stability stable
     */
    get masterAuthorizedNetworksConfig(): ContainerClusterMasterAuthorizedNetworksConfig[];
    /**
     * @stability stable
     */
    set masterAuthorizedNetworksConfig(value: ContainerClusterMasterAuthorizedNetworksConfig[]);
    /**
     * @stability stable
     */
    resetMasterAuthorizedNetworksConfig(): void;
    /**
     * @stability stable
     */
    get masterAuthorizedNetworksConfigInput(): ContainerClusterMasterAuthorizedNetworksConfig[] | undefined;
    private _networkPolicy?;
    /**
     * @stability stable
     */
    get networkPolicy(): ContainerClusterNetworkPolicy[];
    /**
     * @stability stable
     */
    set networkPolicy(value: ContainerClusterNetworkPolicy[]);
    /**
     * @stability stable
     */
    resetNetworkPolicy(): void;
    /**
     * @stability stable
     */
    get networkPolicyInput(): ContainerClusterNetworkPolicy[] | undefined;
    private _nodeConfig?;
    /**
     * @stability stable
     */
    get nodeConfig(): ContainerClusterNodeConfig[];
    /**
     * @stability stable
     */
    set nodeConfig(value: ContainerClusterNodeConfig[]);
    /**
     * @stability stable
     */
    resetNodeConfig(): void;
    /**
     * @stability stable
     */
    get nodeConfigInput(): ContainerClusterNodeConfig[] | undefined;
    private _nodePool?;
    /**
     * @stability stable
     */
    get nodePool(): ContainerClusterNodePool[];
    /**
     * @stability stable
     */
    set nodePool(value: ContainerClusterNodePool[]);
    /**
     * @stability stable
     */
    resetNodePool(): void;
    /**
     * @stability stable
     */
    get nodePoolInput(): ContainerClusterNodePool[] | undefined;
    private _podSecurityPolicyConfig?;
    /**
     * @stability stable
     */
    get podSecurityPolicyConfig(): ContainerClusterPodSecurityPolicyConfig[];
    /**
     * @stability stable
     */
    set podSecurityPolicyConfig(value: ContainerClusterPodSecurityPolicyConfig[]);
    /**
     * @stability stable
     */
    resetPodSecurityPolicyConfig(): void;
    /**
     * @stability stable
     */
    get podSecurityPolicyConfigInput(): ContainerClusterPodSecurityPolicyConfig[] | undefined;
    private _privateClusterConfig?;
    /**
     * @stability stable
     */
    get privateClusterConfig(): ContainerClusterPrivateClusterConfig[];
    /**
     * @stability stable
     */
    set privateClusterConfig(value: ContainerClusterPrivateClusterConfig[]);
    /**
     * @stability stable
     */
    resetPrivateClusterConfig(): void;
    /**
     * @stability stable
     */
    get privateClusterConfigInput(): ContainerClusterPrivateClusterConfig[] | undefined;
    private _releaseChannel?;
    /**
     * @stability stable
     */
    get releaseChannel(): ContainerClusterReleaseChannel[];
    /**
     * @stability stable
     */
    set releaseChannel(value: ContainerClusterReleaseChannel[]);
    /**
     * @stability stable
     */
    resetReleaseChannel(): void;
    /**
     * @stability stable
     */
    get releaseChannelInput(): ContainerClusterReleaseChannel[] | undefined;
    private _resourceUsageExportConfig?;
    /**
     * @stability stable
     */
    get resourceUsageExportConfig(): ContainerClusterResourceUsageExportConfig[];
    /**
     * @stability stable
     */
    set resourceUsageExportConfig(value: ContainerClusterResourceUsageExportConfig[]);
    /**
     * @stability stable
     */
    resetResourceUsageExportConfig(): void;
    /**
     * @stability stable
     */
    get resourceUsageExportConfigInput(): ContainerClusterResourceUsageExportConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ContainerClusterTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ContainerClusterTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ContainerClusterTimeouts | undefined;
    private _verticalPodAutoscaling?;
    /**
     * @stability stable
     */
    get verticalPodAutoscaling(): ContainerClusterVerticalPodAutoscaling[];
    /**
     * @stability stable
     */
    set verticalPodAutoscaling(value: ContainerClusterVerticalPodAutoscaling[]);
    /**
     * @stability stable
     */
    resetVerticalPodAutoscaling(): void;
    /**
     * @stability stable
     */
    get verticalPodAutoscalingInput(): ContainerClusterVerticalPodAutoscaling[] | undefined;
    private _workloadIdentityConfig?;
    /**
     * @stability stable
     */
    get workloadIdentityConfig(): ContainerClusterWorkloadIdentityConfig[];
    /**
     * @stability stable
     */
    set workloadIdentityConfig(value: ContainerClusterWorkloadIdentityConfig[]);
    /**
     * @stability stable
     */
    resetWorkloadIdentityConfig(): void;
    /**
     * @stability stable
     */
    get workloadIdentityConfigInput(): ContainerClusterWorkloadIdentityConfig[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
