import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataCatalogTagTemplateIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy.html#policy_data DataCatalogTagTemplateIamPolicy#policy_data}.
     *
     * @stability stable
     */
    readonly policyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy.html#project DataCatalogTagTemplateIamPolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy.html#region DataCatalogTagTemplateIamPolicy#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy.html#tag_template DataCatalogTagTemplateIamPolicy#tag_template}.
     *
     * @stability stable
     */
    readonly tagTemplate: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy.html google_data_catalog_tag_template_iam_policy}.
 *
 * @stability stable
 */
export declare class DataCatalogTagTemplateIamPolicy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy.html google_data_catalog_tag_template_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataCatalogTagTemplateIamPolicyConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _policyData;
    /**
     * @stability stable
     */
    get policyData(): string;
    /**
     * @stability stable
     */
    set policyData(value: string);
    /**
     * @stability stable
     */
    get policyDataInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _tagTemplate;
    /**
     * @stability stable
     */
    get tagTemplate(): string;
    /**
     * @stability stable
     */
    set tagTemplate(value: string);
    /**
     * @stability stable
     */
    get tagTemplateInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
