import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComposerEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment.html#name DataGoogleComposerEnvironment#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment.html#project DataGoogleComposerEnvironment#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The location or Compute Engine region for the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment.html#region DataGoogleComposerEnvironment#region}
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clusterIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    get clusterSecondaryRangeName(): string;
    /**
     * @stability stable
     */
    get servicesIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    get servicesSecondaryRangeName(): string;
    /**
     * @stability stable
     */
    get useIpAliases(): boolean;
}
/**
 * @stability stable
 */
export declare class DataGoogleComposerEnvironmentConfigNodeConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    get ipAllocationPolicy(): any;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    get zone(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cloudSqlIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    get enablePrivateEndpoint(): boolean;
    /**
     * @stability stable
     */
    get masterIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    get webServerIpv4CidrBlock(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComposerEnvironmentConfigSoftwareConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get airflowConfigOverrides(): any;
    /**
     * @stability stable
     */
    get envVariables(): any;
    /**
     * @stability stable
     */
    get imageVersion(): string;
    /**
     * @stability stable
     */
    get pypiPackages(): any;
    /**
     * @stability stable
     */
    get pythonVersion(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComposerEnvironmentConfigA extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get airflowUri(): string;
    /**
     * @stability stable
     */
    get dagGcsPrefix(): string;
    /**
     * @stability stable
     */
    get gkeCluster(): string;
    /**
     * @stability stable
     */
    get nodeConfig(): any;
    /**
     * @stability stable
     */
    get nodeCount(): number;
    /**
     * @stability stable
     */
    get privateEnvironmentConfig(): any;
    /**
     * @stability stable
     */
    get softwareConfig(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/composer_environment.html google_composer_environment}.
 *
 * @stability stable
 */
export declare class DataGoogleComposerEnvironment extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/composer_environment.html google_composer_environment} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleComposerEnvironmentConfig);
    /**
     * @stability stable
     */
    config(index: string): DataGoogleComposerEnvironmentConfigA;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    labels(key: string): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
