import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeImageConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image.html#family DataGoogleComputeImage#family}.
     *
     * @stability stable
     */
    readonly family?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image.html#filter DataGoogleComputeImage#filter}.
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image.html#name DataGoogleComputeImage#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_image.html#project DataGoogleComputeImage#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_image.html google_compute_image}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeImage extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_image.html google_compute_image} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeImageConfig);
    /**
     * @stability stable
     */
    get archiveSizeBytes(): number;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    private _family?;
    /**
     * @stability stable
     */
    get family(): string;
    /**
     * @stability stable
     */
    set family(value: string);
    /**
     * @stability stable
     */
    resetFamily(): void;
    /**
     * @stability stable
     */
    get familyInput(): string | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get imageEncryptionKeySha256(): string;
    /**
     * @stability stable
     */
    get imageId(): string;
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    /**
     * @stability stable
     */
    labels(key: string): string;
    /**
     * @stability stable
     */
    get licenses(): string[];
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get sourceDisk(): string;
    /**
     * @stability stable
     */
    get sourceDiskEncryptionKeySha256(): string;
    /**
     * @stability stable
     */
    get sourceDiskId(): string;
    /**
     * @stability stable
     */
    get sourceImageId(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
