import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * audit_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#audit_config DataGoogleIamPolicy#audit_config}
     *
     * @stability stable
     */
    readonly auditConfig?: DataGoogleIamPolicyAuditConfig[];
    /**
     * binding block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#binding DataGoogleIamPolicy#binding}
     *
     * @stability stable
     */
    readonly binding?: DataGoogleIamPolicyBinding[];
}
/**
 * @stability stable
 */
export interface DataGoogleIamPolicyAuditConfigAuditLogConfigs {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#exempted_members DataGoogleIamPolicy#exempted_members}.
     *
     * @stability stable
     */
    readonly exemptedMembers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#log_type DataGoogleIamPolicy#log_type}.
     *
     * @stability stable
     */
    readonly logType: string;
}
/**
 * @stability stable
 */
export interface DataGoogleIamPolicyAuditConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#service DataGoogleIamPolicy#service}.
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * audit_log_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#audit_log_configs DataGoogleIamPolicy#audit_log_configs}
     *
     * @stability stable
     */
    readonly auditLogConfigs: DataGoogleIamPolicyAuditConfigAuditLogConfigs[];
}
/**
 * @stability stable
 */
export interface DataGoogleIamPolicyBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#description DataGoogleIamPolicy#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#expression DataGoogleIamPolicy#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#title DataGoogleIamPolicy#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * @stability stable
 */
export interface DataGoogleIamPolicyBinding {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#members DataGoogleIamPolicy#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#role DataGoogleIamPolicy#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#condition DataGoogleIamPolicy#condition}
     *
     * @stability stable
     */
    readonly condition?: DataGoogleIamPolicyBindingCondition[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html google_iam_policy}.
 *
 * @stability stable
 */
export declare class DataGoogleIamPolicy extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html google_iam_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleIamPolicyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get policyData(): string;
    private _auditConfig?;
    /**
     * @stability stable
     */
    get auditConfig(): DataGoogleIamPolicyAuditConfig[];
    /**
     * @stability stable
     */
    set auditConfig(value: DataGoogleIamPolicyAuditConfig[]);
    /**
     * @stability stable
     */
    resetAuditConfig(): void;
    /**
     * @stability stable
     */
    get auditConfigInput(): DataGoogleIamPolicyAuditConfig[] | undefined;
    private _binding?;
    /**
     * @stability stable
     */
    get binding(): DataGoogleIamPolicyBinding[];
    /**
     * @stability stable
     */
    set binding(value: DataGoogleIamPolicyBinding[]);
    /**
     * @stability stable
     */
    resetBinding(): void;
    /**
     * @stability stable
     */
    get bindingInput(): DataGoogleIamPolicyBinding[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
