import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleIapClientConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifier of the brand to which this client is attached to. The format is 'projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iap_client.html#brand DataGoogleIapClient#brand}
     *
     * @stability stable
     */
    readonly brand: string;
    /**
     * Output only. Unique identifier of the OAuth client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iap_client.html#client_id DataGoogleIapClient#client_id}
     *
     * @stability stable
     */
    readonly clientId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/iap_client.html google_iap_client}.
 *
 * @stability stable
 */
export declare class DataGoogleIapClient extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/iap_client.html google_iap_client} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleIapClientConfig);
    private _brand;
    /**
     * @stability stable
     */
    get brand(): string;
    /**
     * @stability stable
     */
    set brand(value: string);
    /**
     * @stability stable
     */
    get brandInput(): string;
    private _clientId;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get secret(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
