import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleProjectsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/projects.html#filter DataGoogleProjects#filter}.
     *
     * @stability stable
     */
    readonly filter: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleProjectsProjects extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get labels(): any;
    /**
     * @stability stable
     */
    get lifecycleState(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get number(): string;
    /**
     * @stability stable
     */
    get parent(): any;
    /**
     * @stability stable
     */
    get projectId(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/projects.html google_projects}.
 *
 * @stability stable
 */
export declare class DataGoogleProjects extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/projects.html google_projects} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleProjectsConfig);
    private _filter;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    get filterInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    projects(index: string): DataGoogleProjectsProjects;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
