import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleSqlCaCertsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_ca_certs.html#instance DataGoogleSqlCaCerts#instance}.
     *
     * @stability stable
     */
    readonly instance: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_ca_certs.html#project DataGoogleSqlCaCerts#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlCaCertsCerts extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cert(): string;
    /**
     * @stability stable
     */
    get commonName(): string;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    get sha1Fingerprint(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/sql_ca_certs.html google_sql_ca_certs}.
 *
 * @stability stable
 */
export declare class DataGoogleSqlCaCerts extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/sql_ca_certs.html google_sql_ca_certs} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleSqlCaCertsConfig);
    /**
     * @stability stable
     */
    get activeVersion(): string;
    /**
     * @stability stable
     */
    certs(index: string): DataGoogleSqlCaCertsCerts;
    /**
     * @stability stable
     */
    get id(): string;
    private _instance;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    get instanceInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
