import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleSqlDatabaseInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the instance.
     *
     * If the name is left blank, Terraform will randomly generate one when the instance is first created. This is done because after a name is used, it cannot be reused for up to one week.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance.html#name DataGoogleSqlDatabaseInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance.html#project DataGoogleSqlDatabaseInstance#project}
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceClone extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get pointInTime(): string;
    /**
     * @stability stable
     */
    get sourceInstanceName(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceIpAddress extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get timeToRetire(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceReplicaConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get caCertificate(): string;
    /**
     * @stability stable
     */
    get clientCertificate(): string;
    /**
     * @stability stable
     */
    get clientKey(): string;
    /**
     * @stability stable
     */
    get connectRetryInterval(): number;
    /**
     * @stability stable
     */
    get dumpFilePath(): string;
    /**
     * @stability stable
     */
    get failoverTarget(): boolean;
    /**
     * @stability stable
     */
    get masterHeartbeatPeriod(): number;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get sslCipher(): string;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    get verifyServerCertificate(): boolean;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceRestoreBackupContext extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get backupRunId(): number;
    /**
     * @stability stable
     */
    get instanceId(): string;
    /**
     * @stability stable
     */
    get project(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceServerCaCert extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cert(): string;
    /**
     * @stability stable
     */
    get commonName(): string;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    get sha1Fingerprint(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get retainedBackups(): number;
    /**
     * @stability stable
     */
    get retentionUnit(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceSettingsBackupConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get backupRetentionSettings(): any;
    /**
     * @stability stable
     */
    get binaryLogEnabled(): boolean;
    /**
     * @stability stable
     */
    get enabled(): boolean;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get pointInTimeRecoveryEnabled(): boolean;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    get transactionLogRetentionDays(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceSettingsDatabaseFlags extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceSettingsInsightsConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get queryInsightsEnabled(): boolean;
    /**
     * @stability stable
     */
    get queryStringLength(): number;
    /**
     * @stability stable
     */
    get recordApplicationTags(): boolean;
    /**
     * @stability stable
     */
    get recordClientAddress(): boolean;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceSettingsIpConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get authorizedNetworks(): any;
    /**
     * @stability stable
     */
    get ipv4Enabled(): boolean;
    /**
     * @stability stable
     */
    get privateNetwork(): string;
    /**
     * @stability stable
     */
    get requireSsl(): boolean;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceSettingsLocationPreference extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get followGaeApplication(): string;
    /**
     * @stability stable
     */
    get zone(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceSettingsMaintenanceWindow extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get day(): number;
    /**
     * @stability stable
     */
    get hour(): number;
    /**
     * @stability stable
     */
    get updateTrack(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstanceSettings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get activationPolicy(): string;
    /**
     * @stability stable
     */
    get authorizedGaeApplications(): string[];
    /**
     * @stability stable
     */
    get availabilityType(): string;
    /**
     * @stability stable
     */
    get backupConfiguration(): any;
    /**
     * @stability stable
     */
    get crashSafeReplication(): boolean;
    /**
     * @stability stable
     */
    get databaseFlags(): any;
    /**
     * @stability stable
     */
    get diskAutoresize(): boolean;
    /**
     * @stability stable
     */
    get diskAutoresizeLimit(): number;
    /**
     * @stability stable
     */
    get diskSize(): number;
    /**
     * @stability stable
     */
    get diskType(): string;
    /**
     * @stability stable
     */
    get insightsConfig(): any;
    /**
     * @stability stable
     */
    get ipConfiguration(): any;
    /**
     * @stability stable
     */
    get locationPreference(): any;
    /**
     * @stability stable
     */
    get maintenanceWindow(): any;
    /**
     * @stability stable
     */
    get pricingPlan(): string;
    /**
     * @stability stable
     */
    get replicationType(): string;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    get userLabels(): any;
    /**
     * @stability stable
     */
    get version(): number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance.html google_sql_database_instance}.
 *
 * @stability stable
 */
export declare class DataGoogleSqlDatabaseInstance extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/sql_database_instance.html google_sql_database_instance} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleSqlDatabaseInstanceConfig);
    /**
     * @stability stable
     */
    clone(index: string): DataGoogleSqlDatabaseInstanceClone;
    /**
     * @stability stable
     */
    get connectionName(): string;
    /**
     * @stability stable
     */
    get databaseVersion(): string;
    /**
     * @stability stable
     */
    get deletionProtection(): boolean;
    /**
     * @stability stable
     */
    get firstIpAddress(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    ipAddress(index: string): DataGoogleSqlDatabaseInstanceIpAddress;
    /**
     * @stability stable
     */
    get masterInstanceName(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicIpAddress(): string;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    replicaConfiguration(index: string): DataGoogleSqlDatabaseInstanceReplicaConfiguration;
    /**
     * @stability stable
     */
    restoreBackupContext(index: string): DataGoogleSqlDatabaseInstanceRestoreBackupContext;
    /**
     * @stability stable
     */
    get rootPassword(): string;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    serverCaCert(index: string): DataGoogleSqlDatabaseInstanceServerCaCert;
    /**
     * @stability stable
     */
    get serviceAccountEmailAddress(): string;
    /**
     * @stability stable
     */
    settings(index: string): DataGoogleSqlDatabaseInstanceSettings;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
