import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleStorageObjectSignedUrlConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#bucket DataGoogleStorageObjectSignedUrl#bucket}.
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#content_md5 DataGoogleStorageObjectSignedUrl#content_md5}.
     *
     * @stability stable
     */
    readonly contentMd5?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#content_type DataGoogleStorageObjectSignedUrl#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#credentials DataGoogleStorageObjectSignedUrl#credentials}.
     *
     * @stability stable
     */
    readonly credentials?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#duration DataGoogleStorageObjectSignedUrl#duration}.
     *
     * @stability stable
     */
    readonly duration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#extension_headers DataGoogleStorageObjectSignedUrl#extension_headers}.
     *
     * @stability stable
     */
    readonly extensionHeaders?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#http_method DataGoogleStorageObjectSignedUrl#http_method}.
     *
     * @stability stable
     */
    readonly httpMethod?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#path DataGoogleStorageObjectSignedUrl#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html google_storage_object_signed_url}.
 *
 * @stability stable
 */
export declare class DataGoogleStorageObjectSignedUrl extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html google_storage_object_signed_url} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleStorageObjectSignedUrlConfig);
    private _bucket;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string;
    private _contentMd5?;
    /**
     * @stability stable
     */
    get contentMd5(): string;
    /**
     * @stability stable
     */
    set contentMd5(value: string);
    /**
     * @stability stable
     */
    resetContentMd5(): void;
    /**
     * @stability stable
     */
    get contentMd5Input(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    set contentType(value: string);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    private _credentials?;
    /**
     * @stability stable
     */
    get credentials(): string;
    /**
     * @stability stable
     */
    set credentials(value: string);
    /**
     * @stability stable
     */
    resetCredentials(): void;
    /**
     * @stability stable
     */
    get credentialsInput(): string | undefined;
    private _duration?;
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    set duration(value: string);
    /**
     * @stability stable
     */
    resetDuration(): void;
    /**
     * @stability stable
     */
    get durationInput(): string | undefined;
    private _extensionHeaders?;
    /**
     * @stability stable
     */
    get extensionHeaders(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set extensionHeaders(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetExtensionHeaders(): void;
    /**
     * @stability stable
     */
    get extensionHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _httpMethod?;
    /**
     * @stability stable
     */
    get httpMethod(): string;
    /**
     * @stability stable
     */
    set httpMethod(value: string);
    /**
     * @stability stable
     */
    resetHttpMethod(): void;
    /**
     * @stability stable
     */
    get httpMethodInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _path;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string;
    /**
     * @stability stable
     */
    get signedUrl(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
