import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleStorageProjectServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html#project DataGoogleStorageProjectServiceAccount#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html#user_project DataGoogleStorageProjectServiceAccount#user_project}.
     *
     * @stability stable
     */
    readonly userProject?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html google_storage_project_service_account}.
 *
 * @stability stable
 */
export declare class DataGoogleStorageProjectServiceAccount extends cdktf.TerraformDataSource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html google_storage_project_service_account} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleStorageProjectServiceAccountConfig);
    /**
     * @stability stable
     */
    get emailAddress(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _userProject?;
    /**
     * @stability stable
     */
    get userProject(): string;
    /**
     * @stability stable
     */
    set userProject(value: string);
    /**
     * @stability stable
     */
    resetUserProject(): void;
    /**
     * @stability stable
     */
    get userProjectInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
