import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the info type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#description DataLossPreventionStoredInfoType#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * User set display name of the info type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#display_name DataLossPreventionStoredInfoType#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The parent of the info type in any of the following formats:.
     *
     * 'projects/{{project}}'
     * 'projects/{{project}}/locations/{{location}}'
     * 'organizations/{{organization_id}}'
     * 'organizations/{{organization_id}}/locations/{{location}}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#parent DataLossPreventionStoredInfoType#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#dictionary DataLossPreventionStoredInfoType#dictionary}
     *
     * @stability stable
     */
    readonly dictionary?: DataLossPreventionStoredInfoTypeDictionary[];
    /**
     * large_custom_dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#large_custom_dictionary DataLossPreventionStoredInfoType#large_custom_dictionary}
     *
     * @stability stable
     */
    readonly largeCustomDictionary?: DataLossPreventionStoredInfoTypeLargeCustomDictionary[];
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#regex DataLossPreventionStoredInfoType#regex}
     *
     * @stability stable
     */
    readonly regex?: DataLossPreventionStoredInfoTypeRegex[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#timeouts DataLossPreventionStoredInfoType#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataLossPreventionStoredInfoTypeTimeouts;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#path DataLossPreventionStoredInfoType#path}
     *
     * @stability stable
     */
    readonly path: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeDictionaryWordList {
    /**
     * Words or phrases defining the dictionary.
     *
     * The dictionary must contain at least one
     * phrase and every phrase must contain at least 2 characters that are letters or digits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#words DataLossPreventionStoredInfoType#words}
     *
     * @stability stable
     */
    readonly words: string[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeDictionary {
    /**
     * cloud_storage_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#cloud_storage_path DataLossPreventionStoredInfoType#cloud_storage_path}
     *
     * @stability stable
     */
    readonly cloudStoragePath?: DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath[];
    /**
     * word_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#word_list DataLossPreventionStoredInfoType#word_list}
     *
     * @stability stable
     */
    readonly wordList?: DataLossPreventionStoredInfoTypeDictionaryWordList[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField {
    /**
     * Name describing the field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#name DataLossPreventionStoredInfoType#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable {
    /**
     * The dataset ID of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#dataset_id DataLossPreventionStoredInfoType#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The Google Cloud Platform project ID of the project containing the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#project_id DataLossPreventionStoredInfoType#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * The name of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#table_id DataLossPreventionStoredInfoType#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField {
    /**
     * field block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#field DataLossPreventionStoredInfoType#field}
     *
     * @stability stable
     */
    readonly field: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField[];
    /**
     * table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#table DataLossPreventionStoredInfoType#table}
     *
     * @stability stable
     */
    readonly table: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet {
    /**
     * The url, in the format 'gs://<bucket>/<path>'. Trailing wildcard in the path is allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#url DataLossPreventionStoredInfoType#url}
     *
     * @stability stable
     */
    readonly url: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#path DataLossPreventionStoredInfoType#path}
     *
     * @stability stable
     */
    readonly path: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionary {
    /**
     * big_query_field block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#big_query_field DataLossPreventionStoredInfoType#big_query_field}
     *
     * @stability stable
     */
    readonly bigQueryField?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField[];
    /**
     * cloud_storage_file_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#cloud_storage_file_set DataLossPreventionStoredInfoType#cloud_storage_file_set}
     *
     * @stability stable
     */
    readonly cloudStorageFileSet?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet[];
    /**
     * output_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#output_path DataLossPreventionStoredInfoType#output_path}
     *
     * @stability stable
     */
    readonly outputPath: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath[];
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified, the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#group_indexes DataLossPreventionStoredInfoType#group_indexes}
     *
     * @stability stable
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#pattern DataLossPreventionStoredInfoType#pattern}
     *
     * @stability stable
     */
    readonly pattern: string;
}
/**
 * @stability stable
 */
export interface DataLossPreventionStoredInfoTypeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#create DataLossPreventionStoredInfoType#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#delete DataLossPreventionStoredInfoType#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#update DataLossPreventionStoredInfoType#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html google_data_loss_prevention_stored_info_type}.
 *
 * @stability stable
 */
export declare class DataLossPreventionStoredInfoType extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html google_data_loss_prevention_stored_info_type} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataLossPreventionStoredInfoTypeConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string;
    private _dictionary?;
    /**
     * @stability stable
     */
    get dictionary(): DataLossPreventionStoredInfoTypeDictionary[];
    /**
     * @stability stable
     */
    set dictionary(value: DataLossPreventionStoredInfoTypeDictionary[]);
    /**
     * @stability stable
     */
    resetDictionary(): void;
    /**
     * @stability stable
     */
    get dictionaryInput(): DataLossPreventionStoredInfoTypeDictionary[] | undefined;
    private _largeCustomDictionary?;
    /**
     * @stability stable
     */
    get largeCustomDictionary(): DataLossPreventionStoredInfoTypeLargeCustomDictionary[];
    /**
     * @stability stable
     */
    set largeCustomDictionary(value: DataLossPreventionStoredInfoTypeLargeCustomDictionary[]);
    /**
     * @stability stable
     */
    resetLargeCustomDictionary(): void;
    /**
     * @stability stable
     */
    get largeCustomDictionaryInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionary[] | undefined;
    private _regex?;
    /**
     * @stability stable
     */
    get regex(): DataLossPreventionStoredInfoTypeRegex[];
    /**
     * @stability stable
     */
    set regex(value: DataLossPreventionStoredInfoTypeRegex[]);
    /**
     * @stability stable
     */
    resetRegex(): void;
    /**
     * @stability stable
     */
    get regexInput(): DataLossPreventionStoredInfoTypeRegex[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DataLossPreventionStoredInfoTypeTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DataLossPreventionStoredInfoTypeTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataLossPreventionStoredInfoTypeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
