import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowAgentConfig extends cdktf.TerraformMetaArguments {
    /**
     * API version displayed in Dialogflow console.
     *
     * If not specified, V2 API is assumed. Clients are free to query
     * different service endpoints for different API versions. However, bots connectors and webhook calls will follow
     * the specified API version.
     * API_VERSION_V1: Legacy V1 API.
     * API_VERSION_V2: V2 API.
     * API_VERSION_V2_BETA_1: V2beta1 API. Possible values: ["API_VERSION_V1", "API_VERSION_V2", "API_VERSION_V2_BETA_1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#api_version DialogflowAgent#api_version}
     *
     * @stability stable
     */
    readonly apiVersion?: string;
    /**
     * The URI of the agent's avatar, which are used throughout the Dialogflow console.
     *
     * When an image URL is entered
     * into this field, the Dialogflow will save the image in the backend. The address of the backend image returned
     * from the API will be shown in the [avatarUriBackend] field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#avatar_uri DialogflowAgent#avatar_uri}
     *
     * @stability stable
     */
    readonly avatarUri?: string;
    /**
     * To filter out false positive results and still get variety in matched natural language inputs for your agent, you can tune the machine learning classification threshold.
     *
     * If the returned score value is less than the threshold
     * value, then a fallback intent will be triggered or, if there are no fallback intents defined, no intent will be
     * triggered. The score values range from 0.0 (completely uncertain) to 1.0 (completely certain). If set to 0.0, the
     * default of 0.3 is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#classification_threshold DialogflowAgent#classification_threshold}
     *
     * @stability stable
     */
    readonly classificationThreshold?: number;
    /**
     * The default language of the agent as a language tag.
     *
     * [See Language Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be updated after creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#default_language_code DialogflowAgent#default_language_code}
     *
     * @stability stable
     */
    readonly defaultLanguageCode: string;
    /**
     * The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#description DialogflowAgent#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name of this agent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#display_name DialogflowAgent#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Determines whether this agent should log conversation queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#enable_logging DialogflowAgent#enable_logging}
     *
     * @stability stable
     */
    readonly enableLogging?: boolean;
    /**
     * Determines how intents are detected from user queries.
     *
     * MATCH_MODE_HYBRID: Best for agents with a small number of examples in intents and/or wide use of templates
     * syntax and composite entities.
     * MATCH_MODE_ML_ONLY: Can be used for agents with a large number of examples in intents, especially the ones
     * using @sys.any or very large developer entities. Possible values: ["MATCH_MODE_HYBRID", "MATCH_MODE_ML_ONLY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#match_mode DialogflowAgent#match_mode}
     *
     * @stability stable
     */
    readonly matchMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#project DialogflowAgent#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The list of all languages supported by this agent (except for the defaultLanguageCode).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#supported_language_codes DialogflowAgent#supported_language_codes}
     *
     * @stability stable
     */
    readonly supportedLanguageCodes?: string[];
    /**
     * The agent tier.
     *
     * If not specified, TIER_STANDARD is assumed.
     * TIER_STANDARD: Standard tier.
     * TIER_ENTERPRISE: Enterprise tier (Essentials).
     * TIER_ENTERPRISE_PLUS: Enterprise tier (Plus).
     * NOTE: Due to consistency issues, the provider will not read this field from the API. Drift is possible between
     * the Terraform state and Dialogflow if the agent tier is changed outside of Terraform. Possible values: ["TIER_STANDARD", "TIER_ENTERPRISE", "TIER_ENTERPRISE_PLUS"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#tier DialogflowAgent#tier}
     *
     * @stability stable
     */
    readonly tier?: string;
    /**
     * The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#time_zone DialogflowAgent#time_zone}
     *
     * @stability stable
     */
    readonly timeZone: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#timeouts DialogflowAgent#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowAgentTimeouts;
}
/**
 * @stability stable
 */
export interface DialogflowAgentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#create DialogflowAgent#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#delete DialogflowAgent#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html#update DialogflowAgent#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html google_dialogflow_agent}.
 *
 * @stability stable
 */
export declare class DialogflowAgent extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_agent.html google_dialogflow_agent} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowAgentConfig);
    private _apiVersion?;
    /**
     * @stability stable
     */
    get apiVersion(): string;
    /**
     * @stability stable
     */
    set apiVersion(value: string);
    /**
     * @stability stable
     */
    resetApiVersion(): void;
    /**
     * @stability stable
     */
    get apiVersionInput(): string | undefined;
    private _avatarUri?;
    /**
     * @stability stable
     */
    get avatarUri(): string;
    /**
     * @stability stable
     */
    set avatarUri(value: string);
    /**
     * @stability stable
     */
    resetAvatarUri(): void;
    /**
     * @stability stable
     */
    get avatarUriInput(): string | undefined;
    /**
     * @stability stable
     */
    get avatarUriBackend(): string;
    private _classificationThreshold?;
    /**
     * @stability stable
     */
    get classificationThreshold(): number;
    /**
     * @stability stable
     */
    set classificationThreshold(value: number);
    /**
     * @stability stable
     */
    resetClassificationThreshold(): void;
    /**
     * @stability stable
     */
    get classificationThresholdInput(): number | undefined;
    private _defaultLanguageCode;
    /**
     * @stability stable
     */
    get defaultLanguageCode(): string;
    /**
     * @stability stable
     */
    set defaultLanguageCode(value: string);
    /**
     * @stability stable
     */
    get defaultLanguageCodeInput(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string;
    private _enableLogging?;
    /**
     * @stability stable
     */
    get enableLogging(): boolean;
    /**
     * @stability stable
     */
    set enableLogging(value: boolean);
    /**
     * @stability stable
     */
    resetEnableLogging(): void;
    /**
     * @stability stable
     */
    get enableLoggingInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _matchMode?;
    /**
     * @stability stable
     */
    get matchMode(): string;
    /**
     * @stability stable
     */
    set matchMode(value: string);
    /**
     * @stability stable
     */
    resetMatchMode(): void;
    /**
     * @stability stable
     */
    get matchModeInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _supportedLanguageCodes?;
    /**
     * @stability stable
     */
    get supportedLanguageCodes(): string[];
    /**
     * @stability stable
     */
    set supportedLanguageCodes(value: string[]);
    /**
     * @stability stable
     */
    resetSupportedLanguageCodes(): void;
    /**
     * @stability stable
     */
    get supportedLanguageCodesInput(): string[] | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    resetTier(): void;
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _timeZone;
    /**
     * @stability stable
     */
    get timeZone(): string;
    /**
     * @stability stable
     */
    set timeZone(value: string);
    /**
     * @stability stable
     */
    get timeZoneInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowAgentTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DialogflowAgentTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowAgentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
