import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowIntentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the action associated with the intent. Note: The action name must not contain whitespaces.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#action DialogflowIntent#action}
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * The list of platforms for which the first responses will be copied from the messages in PLATFORM_UNSPECIFIED (i.e. default platform). Possible values: ["FACEBOOK", "SLACK", "TELEGRAM", "KIK", "SKYPE", "LINE", "VIBER", "ACTIONS_ON_GOOGLE", "GOOGLE_HANGOUTS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#default_response_platforms DialogflowIntent#default_response_platforms}
     *
     * @stability stable
     */
    readonly defaultResponsePlatforms?: string[];
    /**
     * The name of this intent to be displayed on the console.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#display_name DialogflowIntent#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The collection of event names that trigger the intent.
     *
     * If the collection of input contexts is not empty, all of
     * the contexts must be present in the active user session for an event to trigger this intent. See the
     * [events reference](https://cloud.google.com/dialogflow/docs/events-overview) for more details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#events DialogflowIntent#events}
     *
     * @stability stable
     */
    readonly events?: string[];
    /**
     * The list of context names required for this intent to be triggered. Format: projects/<Project ID>/agent/sessions/-/contexts/<Context ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#input_context_names DialogflowIntent#input_context_names}
     *
     * @stability stable
     */
    readonly inputContextNames?: string[];
    /**
     * Indicates whether this is a fallback intent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#is_fallback DialogflowIntent#is_fallback}
     *
     * @stability stable
     */
    readonly isFallback?: boolean;
    /**
     * Indicates whether Machine Learning is disabled for the intent.
     *
     * Note: If mlDisabled setting is set to true, then this intent is not taken into account during inference in ML
     * ONLY match mode. Also, auto-markup in the UI is turned off.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#ml_disabled DialogflowIntent#ml_disabled}
     *
     * @stability stable
     */
    readonly mlDisabled?: boolean;
    /**
     * The unique identifier of the parent intent in the chain of followup intents. Format: projects/<Project ID>/agent/intents/<Intent ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#parent_followup_intent_name DialogflowIntent#parent_followup_intent_name}
     *
     * @stability stable
     */
    readonly parentFollowupIntentName?: string;
    /**
     * The priority of this intent.
     *
     * Higher numbers represent higher priorities.
     * - If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds
     * to the Normal priority in the console.
     * - If the supplied value is negative, the intent is ignored in runtime detect intent requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#priority DialogflowIntent#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#project DialogflowIntent#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Indicates whether to delete all contexts in the current session when this intent is matched.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#reset_contexts DialogflowIntent#reset_contexts}
     *
     * @stability stable
     */
    readonly resetContexts?: boolean;
    /**
     * Indicates whether webhooks are enabled for the intent.
     *
     * WEBHOOK_STATE_ENABLED: Webhook is enabled in the agent and in the intent.
     * WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING: Webhook is enabled in the agent and in the intent. Also, each slot
     * filling prompt is forwarded to the webhook. Possible values: ["WEBHOOK_STATE_ENABLED", "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#webhook_state DialogflowIntent#webhook_state}
     *
     * @stability stable
     */
    readonly webhookState?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#timeouts DialogflowIntent#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowIntentTimeouts;
}
/**
 * @stability stable
 */
export declare class DialogflowIntentFollowupIntentInfo extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get followupIntentName(): string;
    /**
     * @stability stable
     */
    get parentFollowupIntentName(): string;
}
/**
 * @stability stable
 */
export interface DialogflowIntentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#create DialogflowIntent#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#delete DialogflowIntent#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html#update DialogflowIntent#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html google_dialogflow_intent}.
 *
 * @stability stable
 */
export declare class DialogflowIntent extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_intent.html google_dialogflow_intent} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowIntentConfig);
    private _action?;
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    set action(value: string);
    /**
     * @stability stable
     */
    resetAction(): void;
    /**
     * @stability stable
     */
    get actionInput(): string | undefined;
    private _defaultResponsePlatforms?;
    /**
     * @stability stable
     */
    get defaultResponsePlatforms(): string[];
    /**
     * @stability stable
     */
    set defaultResponsePlatforms(value: string[]);
    /**
     * @stability stable
     */
    resetDefaultResponsePlatforms(): void;
    /**
     * @stability stable
     */
    get defaultResponsePlatformsInput(): string[] | undefined;
    private _displayName;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string;
    private _events?;
    /**
     * @stability stable
     */
    get events(): string[];
    /**
     * @stability stable
     */
    set events(value: string[]);
    /**
     * @stability stable
     */
    resetEvents(): void;
    /**
     * @stability stable
     */
    get eventsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    followupIntentInfo(index: string): DialogflowIntentFollowupIntentInfo;
    /**
     * @stability stable
     */
    get id(): string;
    private _inputContextNames?;
    /**
     * @stability stable
     */
    get inputContextNames(): string[];
    /**
     * @stability stable
     */
    set inputContextNames(value: string[]);
    /**
     * @stability stable
     */
    resetInputContextNames(): void;
    /**
     * @stability stable
     */
    get inputContextNamesInput(): string[] | undefined;
    private _isFallback?;
    /**
     * @stability stable
     */
    get isFallback(): boolean;
    /**
     * @stability stable
     */
    set isFallback(value: boolean);
    /**
     * @stability stable
     */
    resetIsFallback(): void;
    /**
     * @stability stable
     */
    get isFallbackInput(): boolean | undefined;
    private _mlDisabled?;
    /**
     * @stability stable
     */
    get mlDisabled(): boolean;
    /**
     * @stability stable
     */
    set mlDisabled(value: boolean);
    /**
     * @stability stable
     */
    resetMlDisabled(): void;
    /**
     * @stability stable
     */
    get mlDisabledInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _parentFollowupIntentName?;
    /**
     * @stability stable
     */
    get parentFollowupIntentName(): string;
    /**
     * @stability stable
     */
    set parentFollowupIntentName(value: string);
    /**
     * @stability stable
     */
    resetParentFollowupIntentName(): void;
    /**
     * @stability stable
     */
    get parentFollowupIntentNameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _resetContexts?;
    /**
     * @stability stable
     */
    get resetContexts(): boolean;
    /**
     * @stability stable
     */
    set resetContexts(value: boolean);
    /**
     * @stability stable
     */
    resetResetContexts(): void;
    /**
     * @stability stable
     */
    get resetContextsInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get rootFollowupIntentName(): string;
    private _webhookState?;
    /**
     * @stability stable
     */
    get webhookState(): string;
    /**
     * @stability stable
     */
    set webhookState(value: string);
    /**
     * @stability stable
     */
    resetWebhookState(): void;
    /**
     * @stability stable
     */
    get webhookStateInput(): string | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowIntentTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: DialogflowIntentTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowIntentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
