import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FirestoreIndexConfig extends cdktf.TerraformMetaArguments {
    /**
     * The collection being indexed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#collection FirestoreIndex#collection}
     *
     * @stability stable
     */
    readonly collection: string;
    /**
     * The Firestore database id. Defaults to '"(default)"'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#database FirestoreIndex#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#project FirestoreIndex#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The scope at which a query is run. Default value: "COLLECTION" Possible values: ["COLLECTION", "COLLECTION_GROUP"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#query_scope FirestoreIndex#query_scope}
     *
     * @stability stable
     */
    readonly queryScope?: string;
    /**
     * fields block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#fields FirestoreIndex#fields}
     *
     * @stability stable
     */
    readonly fields: FirestoreIndexFields[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#timeouts FirestoreIndex#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FirestoreIndexTimeouts;
}
/**
 * @stability stable
 */
export interface FirestoreIndexFields {
    /**
     * Indicates that this field supports operations on arrayValues. Only one of 'order' and 'arrayConfig' can be specified. Possible values: ["CONTAINS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#array_config FirestoreIndex#array_config}
     *
     * @stability stable
     */
    readonly arrayConfig?: string;
    /**
     * Name of the field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#field_path FirestoreIndex#field_path}
     *
     * @stability stable
     */
    readonly fieldPath?: string;
    /**
     * Indicates that this field supports ordering by the specified order or comparing using =, <, <=, >, >=.
     *
     * Only one of 'order' and 'arrayConfig' can be specified. Possible values: ["ASCENDING", "DESCENDING"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#order FirestoreIndex#order}
     *
     * @stability stable
     */
    readonly order?: string;
}
/**
 * @stability stable
 */
export interface FirestoreIndexTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#create FirestoreIndex#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#delete FirestoreIndex#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html google_firestore_index}.
 *
 * @stability stable
 */
export declare class FirestoreIndex extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html google_firestore_index} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FirestoreIndexConfig);
    private _collection;
    /**
     * @stability stable
     */
    get collection(): string;
    /**
     * @stability stable
     */
    set collection(value: string);
    /**
     * @stability stable
     */
    get collectionInput(): string;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    resetDatabase(): void;
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _queryScope?;
    /**
     * @stability stable
     */
    get queryScope(): string;
    /**
     * @stability stable
     */
    set queryScope(value: string);
    /**
     * @stability stable
     */
    resetQueryScope(): void;
    /**
     * @stability stable
     */
    get queryScopeInput(): string | undefined;
    private _fields;
    /**
     * @stability stable
     */
    get fields(): FirestoreIndexFields[];
    /**
     * @stability stable
     */
    set fields(value: FirestoreIndexFields[]);
    /**
     * @stability stable
     */
    get fieldsInput(): FirestoreIndexFields[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): FirestoreIndexTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: FirestoreIndexTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FirestoreIndexTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
