import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#constraint FolderOrganizationPolicy#constraint}
     *
     * @stability stable
     */
    readonly constraint: string;
    /**
     * The resource name of the folder to set the policy for. Its format is folders/{folder_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#folder FolderOrganizationPolicy#folder}
     *
     * @stability stable
     */
    readonly folder: string;
    /**
     * Version of the Policy. Default version is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#version FolderOrganizationPolicy#version}
     *
     * @stability stable
     */
    readonly version?: number;
    /**
     * boolean_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#boolean_policy FolderOrganizationPolicy#boolean_policy}
     *
     * @stability stable
     */
    readonly booleanPolicy?: FolderOrganizationPolicyBooleanPolicy[];
    /**
     * list_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#list_policy FolderOrganizationPolicy#list_policy}
     *
     * @stability stable
     */
    readonly listPolicy?: FolderOrganizationPolicyListPolicy[];
    /**
     * restore_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#restore_policy FolderOrganizationPolicy#restore_policy}
     *
     * @stability stable
     */
    readonly restorePolicy?: FolderOrganizationPolicyRestorePolicy[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#timeouts FolderOrganizationPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FolderOrganizationPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyBooleanPolicy {
    /**
     * If true, then the Policy is enforced. If false, then any configuration is acceptable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#enforced FolderOrganizationPolicy#enforced}
     *
     * @stability stable
     */
    readonly enforced: boolean;
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyListPolicyAllow {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#all FolderOrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#values FolderOrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyListPolicyDeny {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#all FolderOrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#values FolderOrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyListPolicy {
    /**
     * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#inherit_from_parent FolderOrganizationPolicy#inherit_from_parent}
     *
     * @stability stable
     */
    readonly inheritFromParent?: boolean;
    /**
     * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#suggested_value FolderOrganizationPolicy#suggested_value}
     *
     * @stability stable
     */
    readonly suggestedValue?: string;
    /**
     * allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#allow FolderOrganizationPolicy#allow}
     *
     * @stability stable
     */
    readonly allow?: FolderOrganizationPolicyListPolicyAllow[];
    /**
     * deny block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#deny FolderOrganizationPolicy#deny}
     *
     * @stability stable
     */
    readonly deny?: FolderOrganizationPolicyListPolicyDeny[];
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyRestorePolicy {
    /**
     * May only be set to true. If set, then the default Policy is restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#default FolderOrganizationPolicy#default}
     *
     * @stability stable
     */
    readonly default: boolean;
}
/**
 * @stability stable
 */
export interface FolderOrganizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#create FolderOrganizationPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#delete FolderOrganizationPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#read FolderOrganizationPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#update FolderOrganizationPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html google_folder_organization_policy}.
 *
 * @stability stable
 */
export declare class FolderOrganizationPolicy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html google_folder_organization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FolderOrganizationPolicyConfig);
    private _constraint;
    /**
     * @stability stable
     */
    get constraint(): string;
    /**
     * @stability stable
     */
    set constraint(value: string);
    /**
     * @stability stable
     */
    get constraintInput(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    private _folder;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    get folderInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _version?;
    /**
     * @stability stable
     */
    get version(): number;
    /**
     * @stability stable
     */
    set version(value: number);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): number | undefined;
    private _booleanPolicy?;
    /**
     * @stability stable
     */
    get booleanPolicy(): FolderOrganizationPolicyBooleanPolicy[];
    /**
     * @stability stable
     */
    set booleanPolicy(value: FolderOrganizationPolicyBooleanPolicy[]);
    /**
     * @stability stable
     */
    resetBooleanPolicy(): void;
    /**
     * @stability stable
     */
    get booleanPolicyInput(): FolderOrganizationPolicyBooleanPolicy[] | undefined;
    private _listPolicy?;
    /**
     * @stability stable
     */
    get listPolicy(): FolderOrganizationPolicyListPolicy[];
    /**
     * @stability stable
     */
    set listPolicy(value: FolderOrganizationPolicyListPolicy[]);
    /**
     * @stability stable
     */
    resetListPolicy(): void;
    /**
     * @stability stable
     */
    get listPolicyInput(): FolderOrganizationPolicyListPolicy[] | undefined;
    private _restorePolicy?;
    /**
     * @stability stable
     */
    get restorePolicy(): FolderOrganizationPolicyRestorePolicy[];
    /**
     * @stability stable
     */
    set restorePolicy(value: FolderOrganizationPolicyRestorePolicy[]);
    /**
     * @stability stable
     */
    resetRestorePolicy(): void;
    /**
     * @stability stable
     */
    get restorePolicyInput(): FolderOrganizationPolicyRestorePolicy[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): FolderOrganizationPolicyTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: FolderOrganizationPolicyTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FolderOrganizationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
