import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HealthcareConsentStoreIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#consent_store_id HealthcareConsentStoreIamBinding#consent_store_id}.
     *
     * @stability stable
     */
    readonly consentStoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#dataset HealthcareConsentStoreIamBinding#dataset}.
     *
     * @stability stable
     */
    readonly dataset: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#members HealthcareConsentStoreIamBinding#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#role HealthcareConsentStoreIamBinding#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#condition HealthcareConsentStoreIamBinding#condition}
     *
     * @stability stable
     */
    readonly condition?: HealthcareConsentStoreIamBindingCondition[];
}
/**
 * @stability stable
 */
export interface HealthcareConsentStoreIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#description HealthcareConsentStoreIamBinding#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#expression HealthcareConsentStoreIamBinding#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#title HealthcareConsentStoreIamBinding#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html google_healthcare_consent_store_iam_binding}.
 *
 * @stability stable
 */
export declare class HealthcareConsentStoreIamBinding extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html google_healthcare_consent_store_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HealthcareConsentStoreIamBindingConfig);
    private _consentStoreId;
    /**
     * @stability stable
     */
    get consentStoreId(): string;
    /**
     * @stability stable
     */
    set consentStoreId(value: string);
    /**
     * @stability stable
     */
    get consentStoreIdInput(): string;
    private _dataset;
    /**
     * @stability stable
     */
    get dataset(): string;
    /**
     * @stability stable
     */
    set dataset(value: string);
    /**
     * @stability stable
     */
    get datasetInput(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _members;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    get membersInput(): string[];
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): HealthcareConsentStoreIamBindingCondition[];
    /**
     * @stability stable
     */
    set condition(value: HealthcareConsentStoreIamBindingCondition[]);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): HealthcareConsentStoreIamBindingCondition[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
