import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HealthcareConsentStoreIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_policy.html#consent_store_id HealthcareConsentStoreIamPolicy#consent_store_id}.
     *
     * @stability stable
     */
    readonly consentStoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_policy.html#dataset HealthcareConsentStoreIamPolicy#dataset}.
     *
     * @stability stable
     */
    readonly dataset: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_policy.html#policy_data HealthcareConsentStoreIamPolicy#policy_data}.
     *
     * @stability stable
     */
    readonly policyData: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_policy.html google_healthcare_consent_store_iam_policy}.
 *
 * @stability stable
 */
export declare class HealthcareConsentStoreIamPolicy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_policy.html google_healthcare_consent_store_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HealthcareConsentStoreIamPolicyConfig);
    private _consentStoreId;
    /**
     * @stability stable
     */
    get consentStoreId(): string;
    /**
     * @stability stable
     */
    set consentStoreId(value: string);
    /**
     * @stability stable
     */
    get consentStoreIdInput(): string;
    private _dataset;
    /**
     * @stability stable
     */
    get dataset(): string;
    /**
     * @stability stable
     */
    set dataset(value: string);
    /**
     * @stability stable
     */
    get datasetInput(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _policyData;
    /**
     * @stability stable
     */
    get policyData(): string;
    /**
     * @stability stable
     */
    set policyData(value: string);
    /**
     * @stability stable
     */
    get policyDataInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
