import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HealthcareDicomStoreIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store_iam_binding.html#dicom_store_id HealthcareDicomStoreIamBinding#dicom_store_id}.
     *
     * @stability stable
     */
    readonly dicomStoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store_iam_binding.html#members HealthcareDicomStoreIamBinding#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store_iam_binding.html#role HealthcareDicomStoreIamBinding#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store_iam_binding.html#condition HealthcareDicomStoreIamBinding#condition}
     *
     * @stability stable
     */
    readonly condition?: HealthcareDicomStoreIamBindingCondition[];
}
/**
 * @stability stable
 */
export interface HealthcareDicomStoreIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store_iam_binding.html#description HealthcareDicomStoreIamBinding#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store_iam_binding.html#expression HealthcareDicomStoreIamBinding#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store_iam_binding.html#title HealthcareDicomStoreIamBinding#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store_iam_binding.html google_healthcare_dicom_store_iam_binding}.
 *
 * @stability stable
 */
export declare class HealthcareDicomStoreIamBinding extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store_iam_binding.html google_healthcare_dicom_store_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HealthcareDicomStoreIamBindingConfig);
    private _dicomStoreId;
    /**
     * @stability stable
     */
    get dicomStoreId(): string;
    /**
     * @stability stable
     */
    set dicomStoreId(value: string);
    /**
     * @stability stable
     */
    get dicomStoreIdInput(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _members;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    get membersInput(): string[];
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): HealthcareDicomStoreIamBindingCondition[];
    /**
     * @stability stable
     */
    set condition(value: HealthcareDicomStoreIamBindingCondition[]);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): HealthcareDicomStoreIamBindingCondition[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
