import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HealthcareFhirStoreConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifies the dataset addressed by this request. Must be in the format 'projects/{project}/locations/{location}/datasets/{dataset}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#dataset HealthcareFhirStore#dataset}
     *
     * @stability stable
     */
    readonly dataset: string;
    /**
     * Whether to disable referential integrity in this FHIR store.
     *
     * This field is immutable after FHIR store
     * creation. The default value is false, meaning that the API will enforce referential integrity and fail the
     * requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
     * will skip referential integrity check. Consequently, operations that rely on references, such as
     * Patient.get$everything, will not return all the results if broken references exist.
     *
     * * Changing this property may recreate the FHIR store (removing all data) **
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#disable_referential_integrity HealthcareFhirStore#disable_referential_integrity}
     *
     * @stability stable
     */
    readonly disableReferentialIntegrity?: boolean;
    /**
     * Whether to disable resource versioning for this FHIR store.
     *
     * This field can not be changed after the creation
     * of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
     * versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
     * cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
     * attempts to read the historical versions.
     *
     * * Changing this property may recreate the FHIR store (removing all data) **
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#disable_resource_versioning HealthcareFhirStore#disable_resource_versioning}
     *
     * @stability stable
     */
    readonly disableResourceVersioning?: boolean;
    /**
     * Whether to allow the bulk import API to accept history bundles and directly insert historical resource versions into the FHIR store.
     *
     * Importing resource histories creates resource interactions that appear to have
     * occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
     * will fail with an error.
     *
     * * Changing this property may recreate the FHIR store (removing all data) **
     *
     * * This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#enable_history_import HealthcareFhirStore#enable_history_import}
     *
     * @stability stable
     */
    readonly enableHistoryImport?: boolean;
    /**
     * Whether this FHIR store has the updateCreate capability.
     *
     * This determines if the client can use an Update
     * operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
     * the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
     * logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
     * identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
     * notifications.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#enable_update_create HealthcareFhirStore#enable_update_create}
     *
     * @stability stable
     */
    readonly enableUpdateCreate?: boolean;
    /**
     * User-supplied key-value pairs used to organize FHIR stores.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
     * conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     *
     * Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
     * bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     *
     * No more than 64 labels can be associated with a given store.
     *
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#labels HealthcareFhirStore#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The resource name for the FhirStore.
     *
     * * Changing this property may recreate the FHIR store (removing all data) **
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#name HealthcareFhirStore#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The FHIR specification version. Possible values: ["DSTU2", "STU3", "R4"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#version HealthcareFhirStore#version}
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * notification_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#notification_config HealthcareFhirStore#notification_config}
     *
     * @stability stable
     */
    readonly notificationConfig?: HealthcareFhirStoreNotificationConfig[];
    /**
     * stream_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#stream_configs HealthcareFhirStore#stream_configs}
     *
     * @stability stable
     */
    readonly streamConfigs?: HealthcareFhirStoreStreamConfigs[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#timeouts HealthcareFhirStore#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HealthcareFhirStoreTimeouts;
}
/**
 * @stability stable
 */
export interface HealthcareFhirStoreNotificationConfig {
    /**
     * The Cloud Pub/Sub topic that notifications of changes are published on.
     *
     * Supplied by the client.
     * PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
     * It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
     * was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
     * project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
     * Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#pubsub_topic HealthcareFhirStore#pubsub_topic}
     *
     * @stability stable
     */
    readonly pubsubTopic: string;
}
/**
 * @stability stable
 */
export interface HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig {
    /**
     * The depth for all recursive structures in the output analytics schema.
     *
     * For example, concept in the CodeSystem
     * resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called
     * concept.concept but not concept.concept.concept. If not specified or set to 0, the server will use the default
     * value 2. The maximum depth allowed is 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#recursive_structure_depth HealthcareFhirStore#recursive_structure_depth}
     *
     * @stability stable
     */
    readonly recursiveStructureDepth: number;
    /**
     * Specifies the output schema type.
     *
     * Only ANALYTICS is supported at this time.
     * ANALYTICS: Analytics schema defined by the FHIR community.
     * See https://github.com/FHIR/sql-on-fhir/blob/master/sql-on-fhir.md. Default value: "ANALYTICS" Possible values: ["ANALYTICS"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#schema_type HealthcareFhirStore#schema_type}
     *
     * @stability stable
     */
    readonly schemaType?: string;
}
/**
 * @stability stable
 */
export interface HealthcareFhirStoreStreamConfigsBigqueryDestination {
    /**
     * BigQuery URI to a dataset, up to 2000 characters long, in the format bq://projectId.bqDatasetId.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#dataset_uri HealthcareFhirStore#dataset_uri}
     *
     * @stability stable
     */
    readonly datasetUri: string;
    /**
     * schema_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#schema_config HealthcareFhirStore#schema_config}
     *
     * @stability stable
     */
    readonly schemaConfig: HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig[];
}
/**
 * @stability stable
 */
export interface HealthcareFhirStoreStreamConfigs {
    /**
     * Supply a FHIR resource type (such as "Patient" or "Observation").
     *
     * See
     * https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats
     * an empty list as an intent to stream all the supported resource types in this FHIR store.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#resource_types HealthcareFhirStore#resource_types}
     *
     * @stability stable
     */
    readonly resourceTypes?: string[];
    /**
     * bigquery_destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#bigquery_destination HealthcareFhirStore#bigquery_destination}
     *
     * @stability stable
     */
    readonly bigqueryDestination: HealthcareFhirStoreStreamConfigsBigqueryDestination[];
}
/**
 * @stability stable
 */
export interface HealthcareFhirStoreTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#create HealthcareFhirStore#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#delete HealthcareFhirStore#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#update HealthcareFhirStore#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html google_healthcare_fhir_store}.
 *
 * @stability stable
 */
export declare class HealthcareFhirStore extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html google_healthcare_fhir_store} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HealthcareFhirStoreConfig);
    private _dataset;
    /**
     * @stability stable
     */
    get dataset(): string;
    /**
     * @stability stable
     */
    set dataset(value: string);
    /**
     * @stability stable
     */
    get datasetInput(): string;
    private _disableReferentialIntegrity?;
    /**
     * @stability stable
     */
    get disableReferentialIntegrity(): boolean;
    /**
     * @stability stable
     */
    set disableReferentialIntegrity(value: boolean);
    /**
     * @stability stable
     */
    resetDisableReferentialIntegrity(): void;
    /**
     * @stability stable
     */
    get disableReferentialIntegrityInput(): boolean | undefined;
    private _disableResourceVersioning?;
    /**
     * @stability stable
     */
    get disableResourceVersioning(): boolean;
    /**
     * @stability stable
     */
    set disableResourceVersioning(value: boolean);
    /**
     * @stability stable
     */
    resetDisableResourceVersioning(): void;
    /**
     * @stability stable
     */
    get disableResourceVersioningInput(): boolean | undefined;
    private _enableHistoryImport?;
    /**
     * @stability stable
     */
    get enableHistoryImport(): boolean;
    /**
     * @stability stable
     */
    set enableHistoryImport(value: boolean);
    /**
     * @stability stable
     */
    resetEnableHistoryImport(): void;
    /**
     * @stability stable
     */
    get enableHistoryImportInput(): boolean | undefined;
    private _enableUpdateCreate?;
    /**
     * @stability stable
     */
    get enableUpdateCreate(): boolean;
    /**
     * @stability stable
     */
    set enableUpdateCreate(value: boolean);
    /**
     * @stability stable
     */
    resetEnableUpdateCreate(): void;
    /**
     * @stability stable
     */
    get enableUpdateCreateInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _version;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string;
    private _notificationConfig?;
    /**
     * @stability stable
     */
    get notificationConfig(): HealthcareFhirStoreNotificationConfig[];
    /**
     * @stability stable
     */
    set notificationConfig(value: HealthcareFhirStoreNotificationConfig[]);
    /**
     * @stability stable
     */
    resetNotificationConfig(): void;
    /**
     * @stability stable
     */
    get notificationConfigInput(): HealthcareFhirStoreNotificationConfig[] | undefined;
    private _streamConfigs?;
    /**
     * @stability stable
     */
    get streamConfigs(): HealthcareFhirStoreStreamConfigs[];
    /**
     * @stability stable
     */
    set streamConfigs(value: HealthcareFhirStoreStreamConfigs[]);
    /**
     * @stability stable
     */
    resetStreamConfigs(): void;
    /**
     * @stability stable
     */
    get streamConfigsInput(): HealthcareFhirStoreStreamConfigs[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): HealthcareFhirStoreTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: HealthcareFhirStoreTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HealthcareFhirStoreTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
