import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IapAppEngineVersionIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#app_id IapAppEngineVersionIamBinding#app_id}.
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#members IapAppEngineVersionIamBinding#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#project IapAppEngineVersionIamBinding#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#role IapAppEngineVersionIamBinding#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#service IapAppEngineVersionIamBinding#service}.
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#version_id IapAppEngineVersionIamBinding#version_id}.
     *
     * @stability stable
     */
    readonly versionId: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#condition IapAppEngineVersionIamBinding#condition}
     *
     * @stability stable
     */
    readonly condition?: IapAppEngineVersionIamBindingCondition[];
}
/**
 * @stability stable
 */
export interface IapAppEngineVersionIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#description IapAppEngineVersionIamBinding#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#expression IapAppEngineVersionIamBinding#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#title IapAppEngineVersionIamBinding#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html google_iap_app_engine_version_iam_binding}.
 *
 * @stability stable
 */
export declare class IapAppEngineVersionIamBinding extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html google_iap_app_engine_version_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IapAppEngineVersionIamBindingConfig);
    private _appId;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _members;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    get membersInput(): string[];
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _service;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string;
    private _versionId;
    /**
     * @stability stable
     */
    get versionId(): string;
    /**
     * @stability stable
     */
    set versionId(value: string);
    /**
     * @stability stable
     */
    get versionIdInput(): string;
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): IapAppEngineVersionIamBindingCondition[];
    /**
     * @stability stable
     */
    set condition(value: IapAppEngineVersionIamBindingCondition[]);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): IapAppEngineVersionIamBindingCondition[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
