import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IapWebTypeComputeIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_compute_iam_member.html#member IapWebTypeComputeIamMember#member}.
     *
     * @stability stable
     */
    readonly member: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_compute_iam_member.html#project IapWebTypeComputeIamMember#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_compute_iam_member.html#role IapWebTypeComputeIamMember#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_compute_iam_member.html#condition IapWebTypeComputeIamMember#condition}
     *
     * @stability stable
     */
    readonly condition?: IapWebTypeComputeIamMemberCondition[];
}
/**
 * @stability stable
 */
export interface IapWebTypeComputeIamMemberCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_compute_iam_member.html#description IapWebTypeComputeIamMember#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_compute_iam_member.html#expression IapWebTypeComputeIamMember#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_compute_iam_member.html#title IapWebTypeComputeIamMember#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_compute_iam_member.html google_iap_web_type_compute_iam_member}.
 *
 * @stability stable
 */
export declare class IapWebTypeComputeIamMember extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_compute_iam_member.html google_iap_web_type_compute_iam_member} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IapWebTypeComputeIamMemberConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _member;
    /**
     * @stability stable
     */
    get member(): string;
    /**
     * @stability stable
     */
    set member(value: string);
    /**
     * @stability stable
     */
    get memberInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): IapWebTypeComputeIamMemberCondition[];
    /**
     * @stability stable
     */
    set condition(value: IapWebTypeComputeIamMemberCondition[]);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): IapWebTypeComputeIamMemberCondition[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
