import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityPlatformTenantInboundSamlConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Human friendly display name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#display_name IdentityPlatformTenantInboundSamlConfig#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * If this config allows users to sign in with the provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#enabled IdentityPlatformTenantInboundSamlConfig#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean;
    /**
     * The name of the InboundSamlConfig resource.
     *
     * Must start with 'saml.' and can only have alphanumeric characters,
     * hyphens, underscores or periods. The part after 'saml.' must also start with a lowercase letter, end with an
     * alphanumeric character, and have at least 2 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#name IdentityPlatformTenantInboundSamlConfig#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#project IdentityPlatformTenantInboundSamlConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The name of the tenant where this inbound SAML config resource exists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#tenant IdentityPlatformTenantInboundSamlConfig#tenant}
     *
     * @stability stable
     */
    readonly tenant: string;
    /**
     * idp_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#idp_config IdentityPlatformTenantInboundSamlConfig#idp_config}
     *
     * @stability stable
     */
    readonly idpConfig: IdentityPlatformTenantInboundSamlConfigIdpConfig[];
    /**
     * sp_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#sp_config IdentityPlatformTenantInboundSamlConfig#sp_config}
     *
     * @stability stable
     */
    readonly spConfig: IdentityPlatformTenantInboundSamlConfigSpConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#timeouts IdentityPlatformTenantInboundSamlConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IdentityPlatformTenantInboundSamlConfigTimeouts;
}
/**
 * @stability stable
 */
export interface IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates {
    /**
     * The x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#x509_certificate IdentityPlatformTenantInboundSamlConfig#x509_certificate}
     *
     * @stability stable
     */
    readonly x509Certificate?: string;
}
/**
 * @stability stable
 */
export interface IdentityPlatformTenantInboundSamlConfigIdpConfig {
    /**
     * Unique identifier for all SAML entities.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#idp_entity_id IdentityPlatformTenantInboundSamlConfig#idp_entity_id}
     *
     * @stability stable
     */
    readonly idpEntityId: string;
    /**
     * Indicates if outbounding SAMLRequest should be signed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#sign_request IdentityPlatformTenantInboundSamlConfig#sign_request}
     *
     * @stability stable
     */
    readonly signRequest?: boolean;
    /**
     * URL to send Authentication request to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#sso_url IdentityPlatformTenantInboundSamlConfig#sso_url}
     *
     * @stability stable
     */
    readonly ssoUrl: string;
    /**
     * idp_certificates block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#idp_certificates IdentityPlatformTenantInboundSamlConfig#idp_certificates}
     *
     * @stability stable
     */
    readonly idpCertificates: IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[];
}
/**
 * @stability stable
 */
export interface IdentityPlatformTenantInboundSamlConfigSpConfig {
    /**
     * Callback URI where responses from IDP are handled. Must start with 'https://'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#callback_uri IdentityPlatformTenantInboundSamlConfig#callback_uri}
     *
     * @stability stable
     */
    readonly callbackUri: string;
    /**
     * Unique identifier for all SAML entities.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#sp_entity_id IdentityPlatformTenantInboundSamlConfig#sp_entity_id}
     *
     * @stability stable
     */
    readonly spEntityId: string;
}
/**
 * @stability stable
 */
export interface IdentityPlatformTenantInboundSamlConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#create IdentityPlatformTenantInboundSamlConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#delete IdentityPlatformTenantInboundSamlConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#update IdentityPlatformTenantInboundSamlConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html google_identity_platform_tenant_inbound_saml_config}.
 *
 * @stability stable
 */
export declare class IdentityPlatformTenantInboundSamlConfig extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html google_identity_platform_tenant_inbound_saml_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityPlatformTenantInboundSamlConfigConfig);
    private _displayName;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean;
    /**
     * @stability stable
     */
    set enabled(value: boolean);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _tenant;
    /**
     * @stability stable
     */
    get tenant(): string;
    /**
     * @stability stable
     */
    set tenant(value: string);
    /**
     * @stability stable
     */
    get tenantInput(): string;
    private _idpConfig;
    /**
     * @stability stable
     */
    get idpConfig(): IdentityPlatformTenantInboundSamlConfigIdpConfig[];
    /**
     * @stability stable
     */
    set idpConfig(value: IdentityPlatformTenantInboundSamlConfigIdpConfig[]);
    /**
     * @stability stable
     */
    get idpConfigInput(): IdentityPlatformTenantInboundSamlConfigIdpConfig[];
    private _spConfig;
    /**
     * @stability stable
     */
    get spConfig(): IdentityPlatformTenantInboundSamlConfigSpConfig[];
    /**
     * @stability stable
     */
    set spConfig(value: IdentityPlatformTenantInboundSamlConfigSpConfig[]);
    /**
     * @stability stable
     */
    get spConfigInput(): IdentityPlatformTenantInboundSamlConfigSpConfig[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): IdentityPlatformTenantInboundSamlConfigTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: IdentityPlatformTenantInboundSamlConfigTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IdentityPlatformTenantInboundSamlConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
