import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LoggingOrganizationBucketConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the logging bucket. Logging automatically creates two log buckets: _Required and _Default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_bucket_config.html#bucket_id LoggingOrganizationBucketConfig#bucket_id}
     *
     * @stability stable
     */
    readonly bucketId: string;
    /**
     * An optional description for this bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_bucket_config.html#description LoggingOrganizationBucketConfig#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The location of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_bucket_config.html#location LoggingOrganizationBucketConfig#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The parent resource that contains the logging bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_bucket_config.html#organization LoggingOrganizationBucketConfig#organization}
     *
     * @stability stable
     */
    readonly organization: string;
    /**
     * Logs will be retained by default for this amount of time, after which they will automatically be deleted.
     *
     * The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_organization_bucket_config.html#retention_days LoggingOrganizationBucketConfig#retention_days}
     *
     * @stability stable
     */
    readonly retentionDays?: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_organization_bucket_config.html google_logging_organization_bucket_config}.
 *
 * @stability stable
 */
export declare class LoggingOrganizationBucketConfig extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_organization_bucket_config.html google_logging_organization_bucket_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LoggingOrganizationBucketConfigConfig);
    private _bucketId;
    /**
     * @stability stable
     */
    get bucketId(): string;
    /**
     * @stability stable
     */
    set bucketId(value: string);
    /**
     * @stability stable
     */
    get bucketIdInput(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lifecycleState(): string;
    private _location;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _organization;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    set organization(value: string);
    /**
     * @stability stable
     */
    get organizationInput(): string;
    private _retentionDays?;
    /**
     * @stability stable
     */
    get retentionDays(): number;
    /**
     * @stability stable
     */
    set retentionDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionDays(): void;
    /**
     * @stability stable
     */
    get retentionDaysInput(): number | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
