import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * A user-assigned name for this group, used only for display purposes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#display_name MonitoringGroup#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The filter used to determine which monitored resources belong to this group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#filter MonitoringGroup#filter}
     *
     * @stability stable
     */
    readonly filter: string;
    /**
     * If true, the members of this group are considered to be a cluster.
     *
     * The system can perform additional analysis on
     * groups that are clusters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#is_cluster MonitoringGroup#is_cluster}
     *
     * @stability stable
     */
    readonly isCluster?: boolean;
    /**
     * The name of the group's parent, if it has one.
     *
     * The format is
     * "projects/{project_id_or_number}/groups/{group_id}". For
     * groups with no parent, parentName is the empty string, "".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#parent_name MonitoringGroup#parent_name}
     *
     * @stability stable
     */
    readonly parentName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#project MonitoringGroup#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#timeouts MonitoringGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringGroupTimeouts;
}
/**
 * @stability stable
 */
export interface MonitoringGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#create MonitoringGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#delete MonitoringGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html#update MonitoringGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html google_monitoring_group}.
 *
 * @stability stable
 */
export declare class MonitoringGroup extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_group.html google_monitoring_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitoringGroupConfig);
    private _displayName;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string;
    private _filter;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    get filterInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _isCluster?;
    /**
     * @stability stable
     */
    get isCluster(): boolean;
    /**
     * @stability stable
     */
    set isCluster(value: boolean);
    /**
     * @stability stable
     */
    resetIsCluster(): void;
    /**
     * @stability stable
     */
    get isClusterInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _parentName?;
    /**
     * @stability stable
     */
    get parentName(): string;
    /**
     * @stability stable
     */
    set parentName(value: string);
    /**
     * @stability stable
     */
    resetParentName(): void;
    /**
     * @stability stable
     */
    get parentNameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringGroupTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: MonitoringGroupTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
