import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-friendly name for the uptime check configuration.
     *
     * The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#display_name MonitoringUptimeCheckConfig#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * How often, in seconds, the uptime check is performed.
     *
     * Currently, the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10 minutes), and 900s (15 minutes). Optional, defaults to 300s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#period MonitoringUptimeCheckConfig#period}
     *
     * @stability stable
     */
    readonly period?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#project MonitoringUptimeCheckConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The list of regions from which the check will be run.
     *
     * Some regions contain one location, and others contain more than one. If this field is specified, enough regions to include a minimum of 3 locations must be provided, or an error message is returned. Not specifying this field will result in uptime checks running from all regions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#selected_regions MonitoringUptimeCheckConfig#selected_regions}
     *
     * @stability stable
     */
    readonly selectedRegions?: string[];
    /**
     * The maximum amount of time to wait for the request to complete (must be between 1 and 60 seconds).
     *
     * Accepted formats https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.Duration
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#timeout MonitoringUptimeCheckConfig#timeout}
     *
     * @stability stable
     */
    readonly timeout: string;
    /**
     * content_matchers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#content_matchers MonitoringUptimeCheckConfig#content_matchers}
     *
     * @stability stable
     */
    readonly contentMatchers?: MonitoringUptimeCheckConfigContentMatchers[];
    /**
     * http_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#http_check MonitoringUptimeCheckConfig#http_check}
     *
     * @stability stable
     */
    readonly httpCheck?: MonitoringUptimeCheckConfigHttpCheck[];
    /**
     * monitored_resource block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#monitored_resource MonitoringUptimeCheckConfig#monitored_resource}
     *
     * @stability stable
     */
    readonly monitoredResource?: MonitoringUptimeCheckConfigMonitoredResource[];
    /**
     * resource_group block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#resource_group MonitoringUptimeCheckConfig#resource_group}
     *
     * @stability stable
     */
    readonly resourceGroup?: MonitoringUptimeCheckConfigResourceGroup[];
    /**
     * tcp_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#tcp_check MonitoringUptimeCheckConfig#tcp_check}
     *
     * @stability stable
     */
    readonly tcpCheck?: MonitoringUptimeCheckConfigTcpCheck[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#timeouts MonitoringUptimeCheckConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringUptimeCheckConfigTimeouts;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigContentMatchers {
    /**
     * String or regex content to match (max 1024 bytes).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#content MonitoringUptimeCheckConfig#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * The type of content matcher that will be applied to the server output, compared to the content string when the check is run.
     *
     * Default value: "CONTAINS_STRING" Possible values: ["CONTAINS_STRING", "NOT_CONTAINS_STRING", "MATCHES_REGEX", "NON_MATCHES_REGEX"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#matcher MonitoringUptimeCheckConfig#matcher}
     *
     * @stability stable
     */
    readonly matcher?: string;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigHttpCheckAuthInfo {
    /**
     * The password to authenticate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#password MonitoringUptimeCheckConfig#password}
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * The username to authenticate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#username MonitoringUptimeCheckConfig#username}
     *
     * @stability stable
     */
    readonly username: string;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigHttpCheck {
    /**
     * The request body associated with the HTTP POST request.
     *
     * If contentType is URL_ENCODED, the body passed in must be URL-encoded. Users can provide a Content-Length header via the headers field or the API will do so. If the requestMethod is GET and body is not empty, the API will return an error. The maximum byte size is 1 megabyte. Note - As with all bytes fields JSON representations are base64 encoded. e.g. "foo=bar" in URL-encoded form is "foo%3Dbar" and in base64 encoding is "Zm9vJTI1M0RiYXI=".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#body MonitoringUptimeCheckConfig#body}
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * The content type to use for the check. Possible values: ["TYPE_UNSPECIFIED", "URL_ENCODED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#content_type MonitoringUptimeCheckConfig#content_type}
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * The list of headers to send as part of the uptime check request.
     *
     * If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described at https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#headers MonitoringUptimeCheckConfig#headers}
     *
     * @stability stable
     */
    readonly headers?: {
        [key: string]: string;
    };
    /**
     * Boolean specifying whether to encrypt the header information.
     *
     * Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if mask_headers is set to True then the headers will be obscured with ******.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#mask_headers MonitoringUptimeCheckConfig#mask_headers}
     *
     * @stability stable
     */
    readonly maskHeaders?: boolean;
    /**
     * The path to the page to run the check against.
     *
     * Will be combined with the host (specified within the MonitoredResource) and port to construct the full URL. Optional (defaults to "/").
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#path MonitoringUptimeCheckConfig#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * The port to the page to run the check against.
     *
     * Will be combined with host (specified within the MonitoredResource) and path to construct the full URL. Optional (defaults to 80 without SSL, or 443 with SSL).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#port MonitoringUptimeCheckConfig#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * The HTTP request method to use for the check.
     *
     * If set to METHOD_UNSPECIFIED then requestMethod defaults to GET. Default value: "GET" Possible values: ["METHOD_UNSPECIFIED", "GET", "POST"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#request_method MonitoringUptimeCheckConfig#request_method}
     *
     * @stability stable
     */
    readonly requestMethod?: string;
    /**
     * If true, use HTTPS instead of HTTP to run the check.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#use_ssl MonitoringUptimeCheckConfig#use_ssl}
     *
     * @stability stable
     */
    readonly useSsl?: boolean;
    /**
     * Boolean specifying whether to include SSL certificate validation as a part of the Uptime check.
     *
     * Only applies to checks where monitoredResource is set to uptime_url. If useSsl is false, setting validateSsl to true has no effect.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#validate_ssl MonitoringUptimeCheckConfig#validate_ssl}
     *
     * @stability stable
     */
    readonly validateSsl?: boolean;
    /**
     * auth_info block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#auth_info MonitoringUptimeCheckConfig#auth_info}
     *
     * @stability stable
     */
    readonly authInfo?: MonitoringUptimeCheckConfigHttpCheckAuthInfo[];
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigMonitoredResource {
    /**
     * Values for all of the labels listed in the associated monitored resource descriptor.
     *
     * For example, Compute Engine VM instances use the labels "project_id", "instance_id", and "zone".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#labels MonitoringUptimeCheckConfig#labels}
     *
     * @stability stable
     */
    readonly labels: {
        [key: string]: string;
    };
    /**
     * The monitored resource type.
     *
     * This field must match the type field of a MonitoredResourceDescriptor (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.monitoredResourceDescriptors#MonitoredResourceDescriptor) object. For example, the type of a Compute Engine VM instance is gce_instance. For a list of types, see Monitoring resource types (https://cloud.google.com/monitoring/api/resources) and Logging resource types (https://cloud.google.com/logging/docs/api/v2/resource-list).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#type MonitoringUptimeCheckConfig#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigResourceGroup {
    /**
     * The group of resources being monitored. Should be the 'name' of a group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#group_id MonitoringUptimeCheckConfig#group_id}
     *
     * @stability stable
     */
    readonly groupId?: string;
    /**
     * The resource type of the group members. Possible values: ["RESOURCE_TYPE_UNSPECIFIED", "INSTANCE", "AWS_ELB_LOAD_BALANCER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#resource_type MonitoringUptimeCheckConfig#resource_type}
     *
     * @stability stable
     */
    readonly resourceType?: string;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigTcpCheck {
    /**
     * The port to the page to run the check against.
     *
     * Will be combined with host (specified within the MonitoredResource) to construct the full URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#port MonitoringUptimeCheckConfig#port}
     *
     * @stability stable
     */
    readonly port: number;
}
/**
 * @stability stable
 */
export interface MonitoringUptimeCheckConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#create MonitoringUptimeCheckConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#delete MonitoringUptimeCheckConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html#update MonitoringUptimeCheckConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html google_monitoring_uptime_check_config}.
 *
 * @stability stable
 */
export declare class MonitoringUptimeCheckConfig extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_uptime_check_config.html google_monitoring_uptime_check_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitoringUptimeCheckConfigConfig);
    private _displayName;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _period?;
    /**
     * @stability stable
     */
    get period(): string;
    /**
     * @stability stable
     */
    set period(value: string);
    /**
     * @stability stable
     */
    resetPeriod(): void;
    /**
     * @stability stable
     */
    get periodInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _selectedRegions?;
    /**
     * @stability stable
     */
    get selectedRegions(): string[];
    /**
     * @stability stable
     */
    set selectedRegions(value: string[]);
    /**
     * @stability stable
     */
    resetSelectedRegions(): void;
    /**
     * @stability stable
     */
    get selectedRegionsInput(): string[] | undefined;
    private _timeout;
    /**
     * @stability stable
     */
    get timeout(): string;
    /**
     * @stability stable
     */
    set timeout(value: string);
    /**
     * @stability stable
     */
    get timeoutInput(): string;
    /**
     * @stability stable
     */
    get uptimeCheckId(): string;
    private _contentMatchers?;
    /**
     * @stability stable
     */
    get contentMatchers(): MonitoringUptimeCheckConfigContentMatchers[];
    /**
     * @stability stable
     */
    set contentMatchers(value: MonitoringUptimeCheckConfigContentMatchers[]);
    /**
     * @stability stable
     */
    resetContentMatchers(): void;
    /**
     * @stability stable
     */
    get contentMatchersInput(): MonitoringUptimeCheckConfigContentMatchers[] | undefined;
    private _httpCheck?;
    /**
     * @stability stable
     */
    get httpCheck(): MonitoringUptimeCheckConfigHttpCheck[];
    /**
     * @stability stable
     */
    set httpCheck(value: MonitoringUptimeCheckConfigHttpCheck[]);
    /**
     * @stability stable
     */
    resetHttpCheck(): void;
    /**
     * @stability stable
     */
    get httpCheckInput(): MonitoringUptimeCheckConfigHttpCheck[] | undefined;
    private _monitoredResource?;
    /**
     * @stability stable
     */
    get monitoredResource(): MonitoringUptimeCheckConfigMonitoredResource[];
    /**
     * @stability stable
     */
    set monitoredResource(value: MonitoringUptimeCheckConfigMonitoredResource[]);
    /**
     * @stability stable
     */
    resetMonitoredResource(): void;
    /**
     * @stability stable
     */
    get monitoredResourceInput(): MonitoringUptimeCheckConfigMonitoredResource[] | undefined;
    private _resourceGroup?;
    /**
     * @stability stable
     */
    get resourceGroup(): MonitoringUptimeCheckConfigResourceGroup[];
    /**
     * @stability stable
     */
    set resourceGroup(value: MonitoringUptimeCheckConfigResourceGroup[]);
    /**
     * @stability stable
     */
    resetResourceGroup(): void;
    /**
     * @stability stable
     */
    get resourceGroupInput(): MonitoringUptimeCheckConfigResourceGroup[] | undefined;
    private _tcpCheck?;
    /**
     * @stability stable
     */
    get tcpCheck(): MonitoringUptimeCheckConfigTcpCheck[];
    /**
     * @stability stable
     */
    set tcpCheck(value: MonitoringUptimeCheckConfigTcpCheck[]);
    /**
     * @stability stable
     */
    resetTcpCheck(): void;
    /**
     * @stability stable
     */
    get tcpCheckInput(): MonitoringUptimeCheckConfigTcpCheck[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringUptimeCheckConfigTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: MonitoringUptimeCheckConfigTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringUptimeCheckConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
