import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the patch deployment. Length of the description is limited to 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#description OsConfigPatchDeployment#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Duration of the patch.
     *
     * After the duration ends, the patch times out.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#duration OsConfigPatchDeployment#duration}
     *
     * @stability stable
     */
    readonly duration?: string;
    /**
     * A name for the patch deployment in the project.
     *
     * When creating a name the following rules apply:
     * Must contain only lowercase letters, numbers, and hyphens.
     * Must start with a letter.
     * Must be between 1-63 characters.
     * Must end with a number or a letter.
     * Must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#patch_deployment_id OsConfigPatchDeployment#patch_deployment_id}
     *
     * @stability stable
     */
    readonly patchDeploymentId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#project OsConfigPatchDeployment#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * instance_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#instance_filter OsConfigPatchDeployment#instance_filter}
     *
     * @stability stable
     */
    readonly instanceFilter: OsConfigPatchDeploymentInstanceFilter[];
    /**
     * one_time_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#one_time_schedule OsConfigPatchDeployment#one_time_schedule}
     *
     * @stability stable
     */
    readonly oneTimeSchedule?: OsConfigPatchDeploymentOneTimeSchedule[];
    /**
     * patch_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#patch_config OsConfigPatchDeployment#patch_config}
     *
     * @stability stable
     */
    readonly patchConfig?: OsConfigPatchDeploymentPatchConfig[];
    /**
     * recurring_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#recurring_schedule OsConfigPatchDeployment#recurring_schedule}
     *
     * @stability stable
     */
    readonly recurringSchedule?: OsConfigPatchDeploymentRecurringSchedule[];
    /**
     * rollout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#rollout OsConfigPatchDeployment#rollout}
     *
     * @stability stable
     */
    readonly rollout?: OsConfigPatchDeploymentRollout[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#timeouts OsConfigPatchDeployment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: OsConfigPatchDeploymentTimeouts;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentInstanceFilterGroupLabels {
    /**
     * Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#labels OsConfigPatchDeployment#labels}
     *
     * @stability stable
     */
    readonly labels: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentInstanceFilter {
    /**
     * Target all VM instances in the project. If true, no other criteria is permitted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#all OsConfigPatchDeployment#all}
     *
     * @stability stable
     */
    readonly all?: boolean;
    /**
     * Targets VMs whose name starts with one of these prefixes.
     *
     * Similar to labels, this is another way to group
     * VMs when targeting configs, for example prefix="prod-".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#instance_name_prefixes OsConfigPatchDeployment#instance_name_prefixes}
     *
     * @stability stable
     */
    readonly instanceNamePrefixes?: string[];
    /**
     * Targets any of the VM instances specified. Instances are specified by their URI in the 'form zones/{{zone}}/instances/{{instance_name}}', 'projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}', or 'https://www.googleapis.com/compute/v1/projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#instances OsConfigPatchDeployment#instances}
     *
     * @stability stable
     */
    readonly instances?: string[];
    /**
     * Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#zones OsConfigPatchDeployment#zones}
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * group_labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#group_labels OsConfigPatchDeployment#group_labels}
     *
     * @stability stable
     */
    readonly groupLabels?: OsConfigPatchDeploymentInstanceFilterGroupLabels[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentOneTimeSchedule {
    /**
     * The desired patch job execution time. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#execute_time OsConfigPatchDeployment#execute_time}
     *
     * @stability stable
     */
    readonly executeTime: string;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigApt {
    /**
     * List of packages to exclude from update. These packages will be excluded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     *
     * @stability stable
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of packages to be updated.
     *
     * These are the only packages that will be updated.
     * If these packages are not installed, they will be ignored. This field cannot be specified with
     * any other patch configuration fields.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_packages OsConfigPatchDeployment#exclusive_packages}
     *
     * @stability stable
     */
    readonly exclusivePackages?: string[];
    /**
     * By changing the type to DIST, the patching is performed using apt-get dist-upgrade instead. Possible values: ["DIST", "UPGRADE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#type OsConfigPatchDeployment#type}
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigGoo {
    /**
     * goo update settings. Use this setting to override the default goo patch rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#enabled OsConfigPatchDeployment#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     *
     * @stability stable
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     *
     * @stability stable
     */
    readonly object: string;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     *
     * @stability stable
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     *
     * @stability stable
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     *
     * @stability stable
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     *
     * @stability stable
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     *
     * @stability stable
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     *
     * @stability stable
     */
    readonly object: string;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     *
     * @stability stable
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     *
     * @stability stable
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     *
     * @stability stable
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     *
     * @stability stable
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPostStep {
    /**
     * linux_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#linux_exec_step_config OsConfigPatchDeployment#linux_exec_step_config}
     *
     * @stability stable
     */
    readonly linuxExecStepConfig?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig[];
    /**
     * windows_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#windows_exec_step_config OsConfigPatchDeployment#windows_exec_step_config}
     *
     * @stability stable
     */
    readonly windowsExecStepConfig?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     *
     * @stability stable
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     *
     * @stability stable
     */
    readonly object: string;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     *
     * @stability stable
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     *
     * @stability stable
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     *
     * @stability stable
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     *
     * @stability stable
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject {
    /**
     * Bucket of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#bucket OsConfigPatchDeployment#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Generation number of the Cloud Storage object.
     *
     * This is used to ensure that the ExecStep specified by this PatchJob does not change.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#generation_number OsConfigPatchDeployment#generation_number}
     *
     * @stability stable
     */
    readonly generationNumber: string;
    /**
     * Name of the Cloud Storage object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#object OsConfigPatchDeployment#object}
     *
     * @stability stable
     */
    readonly object: string;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig {
    /**
     * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
     *
     * @stability stable
     */
    readonly allowedSuccessCodes?: number[];
    /**
     * The script interpreter to use to run the script.
     *
     * If no interpreter is specified the script will
     * be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#interpreter OsConfigPatchDeployment#interpreter}
     *
     * @stability stable
     */
    readonly interpreter?: string;
    /**
     * An absolute path to the executable on the VM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#local_path OsConfigPatchDeployment#local_path}
     *
     * @stability stable
     */
    readonly localPath?: string;
    /**
     * gcs_object block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#gcs_object OsConfigPatchDeployment#gcs_object}
     *
     * @stability stable
     */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigPreStep {
    /**
     * linux_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#linux_exec_step_config OsConfigPatchDeployment#linux_exec_step_config}
     *
     * @stability stable
     */
    readonly linuxExecStepConfig?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig[];
    /**
     * windows_exec_step_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#windows_exec_step_config OsConfigPatchDeployment#windows_exec_step_config}
     *
     * @stability stable
     */
    readonly windowsExecStepConfig?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigWindowsUpdate {
    /**
     * Only apply updates of these windows update classifications.
     *
     * If empty, all updates are applied. Possible values: ["CRITICAL", "SECURITY", "DEFINITION", "DRIVER", "FEATURE_PACK", "SERVICE_PACK", "TOOL", "UPDATE_ROLLUP", "UPDATE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#classifications OsConfigPatchDeployment#classifications}
     *
     * @stability stable
     */
    readonly classifications?: string[];
    /**
     * List of KBs to exclude from update.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     *
     * @stability stable
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of kbs to be updated.
     *
     * These are the only patches that will be updated.
     * This field must not be used with other patch configurations.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_patches OsConfigPatchDeployment#exclusive_patches}
     *
     * @stability stable
     */
    readonly exclusivePatches?: string[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigYum {
    /**
     * List of packages to exclude from update. These packages will be excluded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     *
     * @stability stable
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of packages to be updated.
     *
     * These are the only packages that will be updated.
     * If these packages are not installed, they will be ignored. This field cannot be specified with
     * any other patch configuration fields.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_packages OsConfigPatchDeployment#exclusive_packages}
     *
     * @stability stable
     */
    readonly exclusivePackages?: string[];
    /**
     * Will cause patch to run yum update-minimal instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#minimal OsConfigPatchDeployment#minimal}
     *
     * @stability stable
     */
    readonly minimal?: boolean;
    /**
     * Adds the --security flag to yum update. Not supported on all platforms.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#security OsConfigPatchDeployment#security}
     *
     * @stability stable
     */
    readonly security?: boolean;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfigZypper {
    /**
     * Install only patches with these categories. Common categories include security, recommended, and feature.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#categories OsConfigPatchDeployment#categories}
     *
     * @stability stable
     */
    readonly categories?: string[];
    /**
     * List of packages to exclude from update.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#excludes OsConfigPatchDeployment#excludes}
     *
     * @stability stable
     */
    readonly excludes?: string[];
    /**
     * An exclusive list of patches to be updated.
     *
     * These are the only patches that will be installed using 'zypper patch patch:' command.
     * This field must not be used with any other patch configuration fields.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#exclusive_patches OsConfigPatchDeployment#exclusive_patches}
     *
     * @stability stable
     */
    readonly exclusivePatches?: string[];
    /**
     * Install only patches with these severities. Common severities include critical, important, moderate, and low.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#severities OsConfigPatchDeployment#severities}
     *
     * @stability stable
     */
    readonly severities?: string[];
    /**
     * Adds the --with-optional flag to zypper patch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#with_optional OsConfigPatchDeployment#with_optional}
     *
     * @stability stable
     */
    readonly withOptional?: boolean;
    /**
     * Adds the --with-update flag, to zypper patch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#with_update OsConfigPatchDeployment#with_update}
     *
     * @stability stable
     */
    readonly withUpdate?: boolean;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentPatchConfig {
    /**
     * Post-patch reboot settings. Possible values: ["DEFAULT", "ALWAYS", "NEVER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#reboot_config OsConfigPatchDeployment#reboot_config}
     *
     * @stability stable
     */
    readonly rebootConfig?: string;
    /**
     * apt block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#apt OsConfigPatchDeployment#apt}
     *
     * @stability stable
     */
    readonly apt?: OsConfigPatchDeploymentPatchConfigApt[];
    /**
     * goo block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#goo OsConfigPatchDeployment#goo}
     *
     * @stability stable
     */
    readonly goo?: OsConfigPatchDeploymentPatchConfigGoo[];
    /**
     * post_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#post_step OsConfigPatchDeployment#post_step}
     *
     * @stability stable
     */
    readonly postStep?: OsConfigPatchDeploymentPatchConfigPostStep[];
    /**
     * pre_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#pre_step OsConfigPatchDeployment#pre_step}
     *
     * @stability stable
     */
    readonly preStep?: OsConfigPatchDeploymentPatchConfigPreStep[];
    /**
     * windows_update block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#windows_update OsConfigPatchDeployment#windows_update}
     *
     * @stability stable
     */
    readonly windowsUpdate?: OsConfigPatchDeploymentPatchConfigWindowsUpdate[];
    /**
     * yum block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#yum OsConfigPatchDeployment#yum}
     *
     * @stability stable
     */
    readonly yum?: OsConfigPatchDeploymentPatchConfigYum[];
    /**
     * zypper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#zypper OsConfigPatchDeployment#zypper}
     *
     * @stability stable
     */
    readonly zypper?: OsConfigPatchDeploymentPatchConfigZypper[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth {
    /**
     * A day of the week. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#day_of_week OsConfigPatchDeployment#day_of_week}
     *
     * @stability stable
     */
    readonly dayOfWeek: string;
    /**
     * Week number in a month.
     *
     * 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#week_ordinal OsConfigPatchDeployment#week_ordinal}
     *
     * @stability stable
     */
    readonly weekOrdinal: number;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringScheduleMonthly {
    /**
     * One day of the month.
     *
     * 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month.
     * Months without the target day will be skipped. For example, a schedule to run "every month on the 31st"
     * will not run in February, April, June, etc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#month_day OsConfigPatchDeployment#month_day}
     *
     * @stability stable
     */
    readonly monthDay?: number;
    /**
     * week_day_of_month block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#week_day_of_month OsConfigPatchDeployment#week_day_of_month}
     *
     * @stability stable
     */
    readonly weekDayOfMonth?: OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringScheduleTimeOfDay {
    /**
     * Hours of day in 24 hour format.
     *
     * Should be from 0 to 23.
     * An API may choose to allow the value "24:00:00" for scenarios like business closing time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#hours OsConfigPatchDeployment#hours}
     *
     * @stability stable
     */
    readonly hours?: number;
    /**
     * Minutes of hour of day. Must be from 0 to 59.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#minutes OsConfigPatchDeployment#minutes}
     *
     * @stability stable
     */
    readonly minutes?: number;
    /**
     * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#nanos OsConfigPatchDeployment#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Seconds of minutes of the time.
     *
     * Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#seconds OsConfigPatchDeployment#seconds}
     *
     * @stability stable
     */
    readonly seconds?: number;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringScheduleTimeZone {
    /**
     * IANA Time Zone Database time zone, e.g. "America/New_York".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#id OsConfigPatchDeployment#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * IANA Time Zone Database version number, e.g. "2019a".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#version OsConfigPatchDeployment#version}
     *
     * @stability stable
     */
    readonly version?: string;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringScheduleWeekly {
    /**
     * IANA Time Zone Database time zone, e.g. "America/New_York". Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#day_of_week OsConfigPatchDeployment#day_of_week}
     *
     * @stability stable
     */
    readonly dayOfWeek: string;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRecurringSchedule {
    /**
     * The end time at which a recurring patch deployment schedule is no longer active.
     *
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#end_time OsConfigPatchDeployment#end_time}
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * The time that the recurring schedule becomes effective.
     *
     * Defaults to createTime of the patch deployment.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#start_time OsConfigPatchDeployment#start_time}
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * monthly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#monthly OsConfigPatchDeployment#monthly}
     *
     * @stability stable
     */
    readonly monthly?: OsConfigPatchDeploymentRecurringScheduleMonthly[];
    /**
     * time_of_day block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#time_of_day OsConfigPatchDeployment#time_of_day}
     *
     * @stability stable
     */
    readonly timeOfDay: OsConfigPatchDeploymentRecurringScheduleTimeOfDay[];
    /**
     * time_zone block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#time_zone OsConfigPatchDeployment#time_zone}
     *
     * @stability stable
     */
    readonly timeZone: OsConfigPatchDeploymentRecurringScheduleTimeZone[];
    /**
     * weekly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#weekly OsConfigPatchDeployment#weekly}
     *
     * @stability stable
     */
    readonly weekly?: OsConfigPatchDeploymentRecurringScheduleWeekly[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRolloutDisruptionBudget {
    /**
     * Specifies a fixed value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#fixed OsConfigPatchDeployment#fixed}
     *
     * @stability stable
     */
    readonly fixed?: number;
    /**
     * Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#percentage OsConfigPatchDeployment#percentage}
     *
     * @stability stable
     */
    readonly percentage?: number;
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentRollout {
    /**
     * Mode of the patch rollout. Possible values: ["ZONE_BY_ZONE", "CONCURRENT_ZONES"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#mode OsConfigPatchDeployment#mode}
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * disruption_budget block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#disruption_budget OsConfigPatchDeployment#disruption_budget}
     *
     * @stability stable
     */
    readonly disruptionBudget: OsConfigPatchDeploymentRolloutDisruptionBudget[];
}
/**
 * @stability stable
 */
export interface OsConfigPatchDeploymentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#create OsConfigPatchDeployment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html#delete OsConfigPatchDeployment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html google_os_config_patch_deployment}.
 *
 * @stability stable
 */
export declare class OsConfigPatchDeployment extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment.html google_os_config_patch_deployment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OsConfigPatchDeploymentConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _duration?;
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    set duration(value: string);
    /**
     * @stability stable
     */
    resetDuration(): void;
    /**
     * @stability stable
     */
    get durationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastExecuteTime(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _patchDeploymentId;
    /**
     * @stability stable
     */
    get patchDeploymentId(): string;
    /**
     * @stability stable
     */
    set patchDeploymentId(value: string);
    /**
     * @stability stable
     */
    get patchDeploymentIdInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _instanceFilter;
    /**
     * @stability stable
     */
    get instanceFilter(): OsConfigPatchDeploymentInstanceFilter[];
    /**
     * @stability stable
     */
    set instanceFilter(value: OsConfigPatchDeploymentInstanceFilter[]);
    /**
     * @stability stable
     */
    get instanceFilterInput(): OsConfigPatchDeploymentInstanceFilter[];
    private _oneTimeSchedule?;
    /**
     * @stability stable
     */
    get oneTimeSchedule(): OsConfigPatchDeploymentOneTimeSchedule[];
    /**
     * @stability stable
     */
    set oneTimeSchedule(value: OsConfigPatchDeploymentOneTimeSchedule[]);
    /**
     * @stability stable
     */
    resetOneTimeSchedule(): void;
    /**
     * @stability stable
     */
    get oneTimeScheduleInput(): OsConfigPatchDeploymentOneTimeSchedule[] | undefined;
    private _patchConfig?;
    /**
     * @stability stable
     */
    get patchConfig(): OsConfigPatchDeploymentPatchConfig[];
    /**
     * @stability stable
     */
    set patchConfig(value: OsConfigPatchDeploymentPatchConfig[]);
    /**
     * @stability stable
     */
    resetPatchConfig(): void;
    /**
     * @stability stable
     */
    get patchConfigInput(): OsConfigPatchDeploymentPatchConfig[] | undefined;
    private _recurringSchedule?;
    /**
     * @stability stable
     */
    get recurringSchedule(): OsConfigPatchDeploymentRecurringSchedule[];
    /**
     * @stability stable
     */
    set recurringSchedule(value: OsConfigPatchDeploymentRecurringSchedule[]);
    /**
     * @stability stable
     */
    resetRecurringSchedule(): void;
    /**
     * @stability stable
     */
    get recurringScheduleInput(): OsConfigPatchDeploymentRecurringSchedule[] | undefined;
    private _rollout?;
    /**
     * @stability stable
     */
    get rollout(): OsConfigPatchDeploymentRollout[];
    /**
     * @stability stable
     */
    set rollout(value: OsConfigPatchDeploymentRollout[]);
    /**
     * @stability stable
     */
    resetRollout(): void;
    /**
     * @stability stable
     */
    get rolloutInput(): OsConfigPatchDeploymentRollout[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): OsConfigPatchDeploymentTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: OsConfigPatchDeploymentTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): OsConfigPatchDeploymentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
