import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OsLoginSshPublicKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * An expiration time in microseconds since epoch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#expiration_time_usec OsLoginSshPublicKey#expiration_time_usec}
     *
     * @stability stable
     */
    readonly expirationTimeUsec?: string;
    /**
     * Public key text in SSH format, defined by RFC4253 section 6.6.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#key OsLoginSshPublicKey#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * The project ID of the Google Cloud Platform project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#project OsLoginSshPublicKey#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The user email.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#user OsLoginSshPublicKey#user}
     *
     * @stability stable
     */
    readonly user: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#timeouts OsLoginSshPublicKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: OsLoginSshPublicKeyTimeouts;
}
/**
 * @stability stable
 */
export interface OsLoginSshPublicKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#create OsLoginSshPublicKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#delete OsLoginSshPublicKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#update OsLoginSshPublicKey#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html google_os_login_ssh_public_key}.
 *
 * @stability stable
 */
export declare class OsLoginSshPublicKey extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html google_os_login_ssh_public_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OsLoginSshPublicKeyConfig);
    private _expirationTimeUsec?;
    /**
     * @stability stable
     */
    get expirationTimeUsec(): string;
    /**
     * @stability stable
     */
    set expirationTimeUsec(value: string);
    /**
     * @stability stable
     */
    resetExpirationTimeUsec(): void;
    /**
     * @stability stable
     */
    get expirationTimeUsecInput(): string | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _key;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _user;
    /**
     * @stability stable
     */
    get user(): string;
    /**
     * @stability stable
     */
    set user(value: string);
    /**
     * @stability stable
     */
    get userInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): OsLoginSshPublicKeyTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: OsLoginSshPublicKeyTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): OsLoginSshPublicKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
