import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProjectServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_service.html#disable_dependent_services ProjectService#disable_dependent_services}.
     *
     * @stability stable
     */
    readonly disableDependentServices?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_service.html#disable_on_destroy ProjectService#disable_on_destroy}.
     *
     * @stability stable
     */
    readonly disableOnDestroy?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_service.html#project ProjectService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_service.html#service ProjectService#service}.
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_service.html#timeouts ProjectService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ProjectServiceTimeouts;
}
/**
 * @stability stable
 */
export interface ProjectServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_service.html#create ProjectService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_service.html#delete ProjectService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_service.html#read ProjectService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_service.html#update ProjectService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_service.html google_project_service}.
 *
 * @stability stable
 */
export declare class ProjectService extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_service.html google_project_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProjectServiceConfig);
    private _disableDependentServices?;
    /**
     * @stability stable
     */
    get disableDependentServices(): boolean;
    /**
     * @stability stable
     */
    set disableDependentServices(value: boolean);
    /**
     * @stability stable
     */
    resetDisableDependentServices(): void;
    /**
     * @stability stable
     */
    get disableDependentServicesInput(): boolean | undefined;
    private _disableOnDestroy?;
    /**
     * @stability stable
     */
    get disableOnDestroy(): boolean;
    /**
     * @stability stable
     */
    set disableOnDestroy(value: boolean);
    /**
     * @stability stable
     */
    resetDisableOnDestroy(): void;
    /**
     * @stability stable
     */
    get disableOnDestroyInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _service;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ProjectServiceTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ProjectServiceTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ProjectServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
