import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PubsubLiteTopicConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#name PubsubLiteTopic#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#project PubsubLiteTopic#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region of the pubsub lite topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#region PubsubLiteTopic#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The zone of the pubsub lite topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#zone PubsubLiteTopic#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * partition_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#partition_config PubsubLiteTopic#partition_config}
     *
     * @stability stable
     */
    readonly partitionConfig?: PubsubLiteTopicPartitionConfig[];
    /**
     * retention_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#retention_config PubsubLiteTopic#retention_config}
     *
     * @stability stable
     */
    readonly retentionConfig?: PubsubLiteTopicRetentionConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#timeouts PubsubLiteTopic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PubsubLiteTopicTimeouts;
}
/**
 * @stability stable
 */
export interface PubsubLiteTopicPartitionConfigCapacity {
    /**
     * Subscribe throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#publish_mib_per_sec PubsubLiteTopic#publish_mib_per_sec}
     *
     * @stability stable
     */
    readonly publishMibPerSec: number;
    /**
     * Publish throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#subscribe_mib_per_sec PubsubLiteTopic#subscribe_mib_per_sec}
     *
     * @stability stable
     */
    readonly subscribeMibPerSec: number;
}
/**
 * @stability stable
 */
export interface PubsubLiteTopicPartitionConfig {
    /**
     * The number of partitions in the topic. Must be at least 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#count PubsubLiteTopic#count}
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * capacity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#capacity PubsubLiteTopic#capacity}
     *
     * @stability stable
     */
    readonly capacity?: PubsubLiteTopicPartitionConfigCapacity[];
}
/**
 * @stability stable
 */
export interface PubsubLiteTopicRetentionConfig {
    /**
     * The provisioned storage, in bytes, per partition.
     *
     * If the number of bytes stored
     * in any of the topic's partitions grows beyond this value, older messages will be
     * dropped to make room for newer ones, regardless of the value of period.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#per_partition_bytes PubsubLiteTopic#per_partition_bytes}
     *
     * @stability stable
     */
    readonly perPartitionBytes: string;
    /**
     * How long a published message is retained.
     *
     * If unset, messages will be retained as
     * long as the bytes retained for each partition is below perPartitionBytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#period PubsubLiteTopic#period}
     *
     * @stability stable
     */
    readonly period?: string;
}
/**
 * @stability stable
 */
export interface PubsubLiteTopicTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#create PubsubLiteTopic#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#delete PubsubLiteTopic#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#update PubsubLiteTopic#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html google_pubsub_lite_topic}.
 *
 * @stability stable
 */
export declare class PubsubLiteTopic extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html google_pubsub_lite_topic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PubsubLiteTopicConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _partitionConfig?;
    /**
     * @stability stable
     */
    get partitionConfig(): PubsubLiteTopicPartitionConfig[];
    /**
     * @stability stable
     */
    set partitionConfig(value: PubsubLiteTopicPartitionConfig[]);
    /**
     * @stability stable
     */
    resetPartitionConfig(): void;
    /**
     * @stability stable
     */
    get partitionConfigInput(): PubsubLiteTopicPartitionConfig[] | undefined;
    private _retentionConfig?;
    /**
     * @stability stable
     */
    get retentionConfig(): PubsubLiteTopicRetentionConfig[];
    /**
     * @stability stable
     */
    set retentionConfig(value: PubsubLiteTopicRetentionConfig[]);
    /**
     * @stability stable
     */
    resetRetentionConfig(): void;
    /**
     * @stability stable
     */
    get retentionConfigInput(): PubsubLiteTopicRetentionConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): PubsubLiteTopicTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: PubsubLiteTopicTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PubsubLiteTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
