import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ResourceManagerLienConfig extends cdktf.TerraformMetaArguments {
    /**
     * A stable, user-visible/meaningful string identifying the origin of the Lien, intended to be inspected programmatically. Maximum length of 200 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien.html#origin ResourceManagerLien#origin}
     *
     * @stability stable
     */
    readonly origin: string;
    /**
     * A reference to the resource this Lien is attached to.
     *
     * The server will validate the parent against those for which Liens are supported.
     * Since a variety of objects can have Liens against them, you must provide the type
     * prefix (e.g. "projects/my-project-name").
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien.html#parent ResourceManagerLien#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * Concise user-visible strings indicating why an action cannot be performed on a resource. Maximum length of 200 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien.html#reason ResourceManagerLien#reason}
     *
     * @stability stable
     */
    readonly reason: string;
    /**
     * The types of operations which should be blocked as a result of this Lien.
     *
     * Each value should correspond to an IAM permission. The server will validate
     * the permissions against those for which Liens are supported.  An empty
     * list is meaningless and will be rejected.
     * e.g. ['resourcemanager.projects.delete']
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien.html#restrictions ResourceManagerLien#restrictions}
     *
     * @stability stable
     */
    readonly restrictions: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien.html#timeouts ResourceManagerLien#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ResourceManagerLienTimeouts;
}
/**
 * @stability stable
 */
export interface ResourceManagerLienTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien.html#create ResourceManagerLien#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien.html#delete ResourceManagerLien#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien.html google_resource_manager_lien}.
 *
 * @stability stable
 */
export declare class ResourceManagerLien extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/resource_manager_lien.html google_resource_manager_lien} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ResourceManagerLienConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _origin;
    /**
     * @stability stable
     */
    get origin(): string;
    /**
     * @stability stable
     */
    set origin(value: string);
    /**
     * @stability stable
     */
    get originInput(): string;
    private _parent;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string;
    private _reason;
    /**
     * @stability stable
     */
    get reason(): string;
    /**
     * @stability stable
     */
    set reason(value: string);
    /**
     * @stability stable
     */
    get reasonInput(): string;
    private _restrictions;
    /**
     * @stability stable
     */
    get restrictions(): string[];
    /**
     * @stability stable
     */
    set restrictions(value: string[]);
    /**
     * @stability stable
     */
    get restrictionsInput(): string[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ResourceManagerLienTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ResourceManagerLienTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ResourceManagerLienTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
