import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecretManagerSecretConfig extends cdktf.TerraformMetaArguments {
    /**
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
     * and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
     * and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     *
     * No more than 64 labels can be assigned to a given resource.
     *
     * An object containing a list of "key": value pairs. Example:
     * { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#labels SecretManagerSecret#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#project SecretManagerSecret#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * This must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#secret_id SecretManagerSecret#secret_id}
     *
     * @stability stable
     */
    readonly secretId: string;
    /**
     * replication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#replication SecretManagerSecret#replication}
     *
     * @stability stable
     */
    readonly replication: SecretManagerSecretReplication[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#timeouts SecretManagerSecret#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SecretManagerSecretTimeouts;
}
/**
 * @stability stable
 */
export interface SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination secret.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#kms_key_name SecretManagerSecret#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
/**
 * @stability stable
 */
export interface SecretManagerSecretReplicationUserManagedReplicas {
    /**
     * The canonical IDs of the location to replicate data. For example: "us-east1".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#location SecretManagerSecret#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * customer_managed_encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#customer_managed_encryption SecretManagerSecret#customer_managed_encryption}
     *
     * @stability stable
     */
    readonly customerManagedEncryption?: SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption[];
}
/**
 * @stability stable
 */
export interface SecretManagerSecretReplicationUserManaged {
    /**
     * replicas block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#replicas SecretManagerSecret#replicas}
     *
     * @stability stable
     */
    readonly replicas: SecretManagerSecretReplicationUserManagedReplicas[];
}
/**
 * @stability stable
 */
export interface SecretManagerSecretReplication {
    /**
     * The Secret will automatically be replicated without any restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#automatic SecretManagerSecret#automatic}
     *
     * @stability stable
     */
    readonly automatic?: boolean;
    /**
     * user_managed block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#user_managed SecretManagerSecret#user_managed}
     *
     * @stability stable
     */
    readonly userManaged?: SecretManagerSecretReplicationUserManaged[];
}
/**
 * @stability stable
 */
export interface SecretManagerSecretTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#create SecretManagerSecret#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#delete SecretManagerSecret#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html#update SecretManagerSecret#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html google_secret_manager_secret}.
 *
 * @stability stable
 */
export declare class SecretManagerSecret extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret.html google_secret_manager_secret} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecretManagerSecretConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _secretId;
    /**
     * @stability stable
     */
    get secretId(): string;
    /**
     * @stability stable
     */
    set secretId(value: string);
    /**
     * @stability stable
     */
    get secretIdInput(): string;
    private _replication;
    /**
     * @stability stable
     */
    get replication(): SecretManagerSecretReplication[];
    /**
     * @stability stable
     */
    set replication(value: SecretManagerSecretReplication[]);
    /**
     * @stability stable
     */
    get replicationInput(): SecretManagerSecretReplication[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): SecretManagerSecretTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: SecretManagerSecretTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SecretManagerSecretTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
