import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceAccountIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding.html#members ServiceAccountIamBinding#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding.html#role ServiceAccountIamBinding#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding.html#service_account_id ServiceAccountIamBinding#service_account_id}.
     *
     * @stability stable
     */
    readonly serviceAccountId: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding.html#condition ServiceAccountIamBinding#condition}
     *
     * @stability stable
     */
    readonly condition?: ServiceAccountIamBindingCondition[];
}
/**
 * @stability stable
 */
export interface ServiceAccountIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding.html#description ServiceAccountIamBinding#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding.html#expression ServiceAccountIamBinding#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding.html#title ServiceAccountIamBinding#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding.html google_service_account_iam_binding}.
 *
 * @stability stable
 */
export declare class ServiceAccountIamBinding extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding.html google_service_account_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceAccountIamBindingConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _members;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    get membersInput(): string[];
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _serviceAccountId;
    /**
     * @stability stable
     */
    get serviceAccountId(): string;
    /**
     * @stability stable
     */
    set serviceAccountId(value: string);
    /**
     * @stability stable
     */
    get serviceAccountIdInput(): string;
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): ServiceAccountIamBindingCondition[];
    /**
     * @stability stable
     */
    set condition(value: ServiceAccountIamBindingCondition[]);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): ServiceAccountIamBindingCondition[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
