import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * The account id that is used to generate the service account email address and a stable unique id.
     *
     * It is unique within a project, must be 6-30 characters long, and match the regular expression [a-z]([-a-z0-9]*[a-z0-9]) to comply with RFC1035. Changing this forces a new service account to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#account_id ServiceAccount#account_id}
     *
     * @stability stable
     */
    readonly accountId: string;
    /**
     * A text description of the service account. Must be less than or equal to 256 UTF-8 bytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#description ServiceAccount#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The display name for the service account. Can be updated without creating a new resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#display_name ServiceAccount#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The ID of the project that the service account will be created in. Defaults to the provider project configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#project ServiceAccount#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#timeouts ServiceAccount#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServiceAccountTimeouts;
}
/**
 * @stability stable
 */
export interface ServiceAccountTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account.html#create ServiceAccount#create}.
     *
     * @stability stable
     */
    readonly create?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/service_account.html google_service_account}.
 *
 * @stability stable
 */
export declare class ServiceAccount extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_account.html google_service_account} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceAccountConfig);
    private _accountId;
    /**
     * @stability stable
     */
    get accountId(): string;
    /**
     * @stability stable
     */
    set accountId(value: string);
    /**
     * @stability stable
     */
    get accountIdInput(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get uniqueId(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ServiceAccountTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ServiceAccountTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServiceAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
