import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The MySQL, PostgreSQL or SQL Server (beta) version to use.
     *
     * Supported values include MYSQL_5_6, MYSQL_5_7, MYSQL_8_0, POSTGRES_9_6, POSTGRES_10, POSTGRES_11, POSTGRES_12, POSTGRES_13, SQLSERVER_2017_STANDARD, SQLSERVER_2017_ENTERPRISE, SQLSERVER_2017_EXPRESS, SQLSERVER_2017_WEB. Database Version Policies includes an up-to-date reference of supported versions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#database_version SqlDatabaseInstance#database_version}
     *
     * @stability stable
     */
    readonly databaseVersion?: string;
    /**
     * Used to block Terraform from deleting a SQL Instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#deletion_protection SqlDatabaseInstance#deletion_protection}
     *
     * @stability stable
     */
    readonly deletionProtection?: boolean;
    /**
     * The name of the instance that will act as the master in the replication setup.
     *
     * Note, this requires the master to have binary_log_enabled set, as well as existing backups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#master_instance_name SqlDatabaseInstance#master_instance_name}
     *
     * @stability stable
     */
    readonly masterInstanceName?: string;
    /**
     * The name of the instance.
     *
     * If the name is left blank, Terraform will randomly generate one when the instance is first created. This is done because after a name is used, it cannot be reused for up to one week.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#name SqlDatabaseInstance#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#project SqlDatabaseInstance#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region the instance will sit in.
     *
     * Note, Cloud SQL is not available in all regions. A valid region must be provided to use this resource. If a region is not provided in the resource definition, the provider region will be used instead, but this will be an apply-time error for instances if the provider region is not supported with Cloud SQL. If you choose not to provide the region argument for this resource, make sure you understand this.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#region SqlDatabaseInstance#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Initial root password. Required for MS SQL Server, ignored by MySQL and PostgreSQL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#root_password SqlDatabaseInstance#root_password}
     *
     * @stability stable
     */
    readonly rootPassword?: string;
    /**
     * clone block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#clone SqlDatabaseInstance#clone}
     *
     * @stability stable
     */
    readonly clone?: SqlDatabaseInstanceClone[];
    /**
     * replica_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#replica_configuration SqlDatabaseInstance#replica_configuration}
     *
     * @stability stable
     */
    readonly replicaConfiguration?: SqlDatabaseInstanceReplicaConfiguration[];
    /**
     * restore_backup_context block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#restore_backup_context SqlDatabaseInstance#restore_backup_context}
     *
     * @stability stable
     */
    readonly restoreBackupContext?: SqlDatabaseInstanceRestoreBackupContext[];
    /**
     * settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#settings SqlDatabaseInstance#settings}
     *
     * @stability stable
     */
    readonly settings?: SqlDatabaseInstanceSettings[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#timeouts SqlDatabaseInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SqlDatabaseInstanceTimeouts;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceIpAddress extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get timeToRetire(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceServerCaCert extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cert(): string;
    /**
     * @stability stable
     */
    get commonName(): string;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    get sha1Fingerprint(): string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceClone {
    /**
     * The timestamp of the point in time that should be restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#point_in_time SqlDatabaseInstance#point_in_time}
     *
     * @stability stable
     */
    readonly pointInTime?: string;
    /**
     * The name of the instance from which the point in time should be restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#source_instance_name SqlDatabaseInstance#source_instance_name}
     *
     * @stability stable
     */
    readonly sourceInstanceName: string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceReplicaConfiguration {
    /**
     * PEM representation of the trusted CA's x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ca_certificate SqlDatabaseInstance#ca_certificate}
     *
     * @stability stable
     */
    readonly caCertificate?: string;
    /**
     * PEM representation of the replica's x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#client_certificate SqlDatabaseInstance#client_certificate}
     *
     * @stability stable
     */
    readonly clientCertificate?: string;
    /**
     * PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#client_key SqlDatabaseInstance#client_key}
     *
     * @stability stable
     */
    readonly clientKey?: string;
    /**
     * The number of seconds between connect retries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#connect_retry_interval SqlDatabaseInstance#connect_retry_interval}
     *
     * @stability stable
     */
    readonly connectRetryInterval?: number;
    /**
     * Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#dump_file_path SqlDatabaseInstance#dump_file_path}
     *
     * @stability stable
     */
    readonly dumpFilePath?: string;
    /**
     * Specifies if the replica is the failover target.
     *
     * If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#failover_target SqlDatabaseInstance#failover_target}
     *
     * @stability stable
     */
    readonly failoverTarget?: boolean;
    /**
     * Time in ms between replication heartbeats.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#master_heartbeat_period SqlDatabaseInstance#master_heartbeat_period}
     *
     * @stability stable
     */
    readonly masterHeartbeatPeriod?: number;
    /**
     * Password for the replication connection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#password SqlDatabaseInstance#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Permissible ciphers for use in SSL encryption.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ssl_cipher SqlDatabaseInstance#ssl_cipher}
     *
     * @stability stable
     */
    readonly sslCipher?: string;
    /**
     * Username for replication connection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#username SqlDatabaseInstance#username}
     *
     * @stability stable
     */
    readonly username?: string;
    /**
     * True if the master's common name value is checked during the SSL handshake.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#verify_server_certificate SqlDatabaseInstance#verify_server_certificate}
     *
     * @stability stable
     */
    readonly verifyServerCertificate?: boolean;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceRestoreBackupContext {
    /**
     * The ID of the backup run to restore from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#backup_run_id SqlDatabaseInstance#backup_run_id}
     *
     * @stability stable
     */
    readonly backupRunId: number;
    /**
     * The ID of the instance that the backup was taken from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#instance_id SqlDatabaseInstance#instance_id}
     *
     * @stability stable
     */
    readonly instanceId?: string;
    /**
     * The full project ID of the source instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#project SqlDatabaseInstance#project}
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings {
    /**
     * Number of backups to retain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#retained_backups SqlDatabaseInstance#retained_backups}
     *
     * @stability stable
     */
    readonly retainedBackups: number;
    /**
     * The unit that 'retainedBackups' represents. Defaults to COUNT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#retention_unit SqlDatabaseInstance#retention_unit}
     *
     * @stability stable
     */
    readonly retentionUnit?: string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsBackupConfiguration {
    /**
     * True if binary logging is enabled.
     *
     * If settings.backup_configuration.enabled is false, this must be as well. Cannot be used with Postgres.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#binary_log_enabled SqlDatabaseInstance#binary_log_enabled}
     *
     * @stability stable
     */
    readonly binaryLogEnabled?: boolean;
    /**
     * True if backup configuration is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#enabled SqlDatabaseInstance#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean;
    /**
     * Location of the backup configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#location SqlDatabaseInstance#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * True if Point-in-time recovery is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#point_in_time_recovery_enabled SqlDatabaseInstance#point_in_time_recovery_enabled}
     *
     * @stability stable
     */
    readonly pointInTimeRecoveryEnabled?: boolean;
    /**
     * HH:MM format time indicating when backup configuration starts.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#start_time SqlDatabaseInstance#start_time}
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * The number of days of transaction logs we retain for point in time restore, from 1-7.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#transaction_log_retention_days SqlDatabaseInstance#transaction_log_retention_days}
     *
     * @stability stable
     */
    readonly transactionLogRetentionDays?: number;
    /**
     * backup_retention_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#backup_retention_settings SqlDatabaseInstance#backup_retention_settings}
     *
     * @stability stable
     */
    readonly backupRetentionSettings?: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings[];
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsDatabaseFlags {
    /**
     * Name of the flag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#name SqlDatabaseInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Value of the flag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#value SqlDatabaseInstance#value}
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsInsightsConfig {
    /**
     * True if Query Insights feature is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#query_insights_enabled SqlDatabaseInstance#query_insights_enabled}
     *
     * @stability stable
     */
    readonly queryInsightsEnabled?: boolean;
    /**
     * Maximum query length stored in bytes. Between 256 and 4500. Default to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#query_string_length SqlDatabaseInstance#query_string_length}
     *
     * @stability stable
     */
    readonly queryStringLength?: number;
    /**
     * True if Query Insights will record application tags from query when enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#record_application_tags SqlDatabaseInstance#record_application_tags}
     *
     * @stability stable
     */
    readonly recordApplicationTags?: boolean;
    /**
     * True if Query Insights will record client address when enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#record_client_address SqlDatabaseInstance#record_client_address}
     *
     * @stability stable
     */
    readonly recordClientAddress?: boolean;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#expiration_time SqlDatabaseInstance#expiration_time}.
     *
     * @stability stable
     */
    readonly expirationTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#name SqlDatabaseInstance#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#value SqlDatabaseInstance#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsIpConfiguration {
    /**
     * Whether this Cloud SQL instance should be assigned a public IPV4 address.
     *
     * At least ipv4_enabled must be enabled or a private_network must be configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ipv4_enabled SqlDatabaseInstance#ipv4_enabled}
     *
     * @stability stable
     */
    readonly ipv4Enabled?: boolean;
    /**
     * The VPC network from which the Cloud SQL instance is accessible for private IP.
     *
     * For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#private_network SqlDatabaseInstance#private_network}
     *
     * @stability stable
     */
    readonly privateNetwork?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#require_ssl SqlDatabaseInstance#require_ssl}.
     *
     * @stability stable
     */
    readonly requireSsl?: boolean;
    /**
     * authorized_networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#authorized_networks SqlDatabaseInstance#authorized_networks}
     *
     * @stability stable
     */
    readonly authorizedNetworks?: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[];
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsLocationPreference {
    /**
     * A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#follow_gae_application SqlDatabaseInstance#follow_gae_application}
     *
     * @stability stable
     */
    readonly followGaeApplication?: string;
    /**
     * The preferred compute engine zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#zone SqlDatabaseInstance#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsMaintenanceWindow {
    /**
     * Day of week (1-7), starting on Monday.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#day SqlDatabaseInstance#day}
     *
     * @stability stable
     */
    readonly day?: number;
    /**
     * Hour of day (0-23), ignored if day not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#hour SqlDatabaseInstance#hour}
     *
     * @stability stable
     */
    readonly hour?: number;
    /**
     * Receive updates earlier (canary) or later (stable).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#update_track SqlDatabaseInstance#update_track}
     *
     * @stability stable
     */
    readonly updateTrack?: string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettings {
    /**
     * This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#activation_policy SqlDatabaseInstance#activation_policy}
     *
     * @stability stable
     */
    readonly activationPolicy?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see https://cloud.google.com/sql/docs/mysql/deprecation-notice for information on how to upgrade to Second Generation instances. A list of Google App Engine project names that are allowed to access this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#authorized_gae_applications SqlDatabaseInstance#authorized_gae_applications}
     *
     * @stability stable
     */
    readonly authorizedGaeApplications?: string[];
    /**
     * The availability type of the Cloud SQL instance, high availability (REGIONAL) or single zone (ZONAL).
     *
     * For MySQL instances, ensure that
     * settings.backup_configuration.enabled and
     * settings.backup_configuration.binary_log_enabled are both set to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#availability_type SqlDatabaseInstance#availability_type}
     *
     * @stability stable
     */
    readonly availabilityType?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see here for information on how to upgrade to Second Generation instances. Specific to read instances, indicates when crash-safe replication flags are enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#crash_safe_replication SqlDatabaseInstance#crash_safe_replication}
     *
     * @stability stable
     */
    readonly crashSafeReplication?: boolean;
    /**
     * Configuration to increase storage size automatically.
     *
     * Note that future terraform apply calls will attempt to resize the disk to the value specified in disk_size - if this is set, do not set disk_size.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_autoresize SqlDatabaseInstance#disk_autoresize}
     *
     * @stability stable
     */
    readonly diskAutoresize?: boolean;
    /**
     * The maximum size, in GB, to which storage capacity can be automatically increased.
     *
     * The default value is 0, which specifies that there is no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_autoresize_limit SqlDatabaseInstance#disk_autoresize_limit}
     *
     * @stability stable
     */
    readonly diskAutoresizeLimit?: number;
    /**
     * The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_size SqlDatabaseInstance#disk_size}
     *
     * @stability stable
     */
    readonly diskSize?: number;
    /**
     * The type of data disk: PD_SSD or PD_HDD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_type SqlDatabaseInstance#disk_type}
     *
     * @stability stable
     */
    readonly diskType?: string;
    /**
     * Pricing plan for this instance, can only be PER_USE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#pricing_plan SqlDatabaseInstance#pricing_plan}
     *
     * @stability stable
     */
    readonly pricingPlan?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see here for information on how to upgrade to Second Generation instances. Replication type for this instance, can be one of ASYNCHRONOUS or SYNCHRONOUS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#replication_type SqlDatabaseInstance#replication_type}
     *
     * @stability stable
     */
    readonly replicationType?: string;
    /**
     * The machine type to use.
     *
     * See tiers for more details and supported versions. Postgres supports only shared-core machine types, and custom machine types such as db-custom-2-13312. See the Custom Machine Type Documentation to learn about specifying custom machine types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#tier SqlDatabaseInstance#tier}
     *
     * @stability stable
     */
    readonly tier: string;
    /**
     * A set of key/value user label pairs to assign to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#user_labels SqlDatabaseInstance#user_labels}
     *
     * @stability stable
     */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
     * backup_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#backup_configuration SqlDatabaseInstance#backup_configuration}
     *
     * @stability stable
     */
    readonly backupConfiguration?: SqlDatabaseInstanceSettingsBackupConfiguration[];
    /**
     * database_flags block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#database_flags SqlDatabaseInstance#database_flags}
     *
     * @stability stable
     */
    readonly databaseFlags?: SqlDatabaseInstanceSettingsDatabaseFlags[];
    /**
     * insights_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#insights_config SqlDatabaseInstance#insights_config}
     *
     * @stability stable
     */
    readonly insightsConfig?: SqlDatabaseInstanceSettingsInsightsConfig[];
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ip_configuration SqlDatabaseInstance#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration?: SqlDatabaseInstanceSettingsIpConfiguration[];
    /**
     * location_preference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#location_preference SqlDatabaseInstance#location_preference}
     *
     * @stability stable
     */
    readonly locationPreference?: SqlDatabaseInstanceSettingsLocationPreference[];
    /**
     * maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#maintenance_window SqlDatabaseInstance#maintenance_window}
     *
     * @stability stable
     */
    readonly maintenanceWindow?: SqlDatabaseInstanceSettingsMaintenanceWindow[];
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#create SqlDatabaseInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#delete SqlDatabaseInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#update SqlDatabaseInstance#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html google_sql_database_instance}.
 *
 * @stability stable
 */
export declare class SqlDatabaseInstance extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html google_sql_database_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: SqlDatabaseInstanceConfig);
    /**
     * @stability stable
     */
    get connectionName(): string;
    private _databaseVersion?;
    /**
     * @stability stable
     */
    get databaseVersion(): string;
    /**
     * @stability stable
     */
    set databaseVersion(value: string);
    /**
     * @stability stable
     */
    resetDatabaseVersion(): void;
    /**
     * @stability stable
     */
    get databaseVersionInput(): string | undefined;
    private _deletionProtection?;
    /**
     * @stability stable
     */
    get deletionProtection(): boolean;
    /**
     * @stability stable
     */
    set deletionProtection(value: boolean);
    /**
     * @stability stable
     */
    resetDeletionProtection(): void;
    /**
     * @stability stable
     */
    get deletionProtectionInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get firstIpAddress(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    ipAddress(index: string): SqlDatabaseInstanceIpAddress;
    private _masterInstanceName?;
    /**
     * @stability stable
     */
    get masterInstanceName(): string;
    /**
     * @stability stable
     */
    set masterInstanceName(value: string);
    /**
     * @stability stable
     */
    resetMasterInstanceName(): void;
    /**
     * @stability stable
     */
    get masterInstanceNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicIpAddress(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _rootPassword?;
    /**
     * @stability stable
     */
    get rootPassword(): string;
    /**
     * @stability stable
     */
    set rootPassword(value: string);
    /**
     * @stability stable
     */
    resetRootPassword(): void;
    /**
     * @stability stable
     */
    get rootPasswordInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    serverCaCert(index: string): SqlDatabaseInstanceServerCaCert;
    /**
     * @stability stable
     */
    get serviceAccountEmailAddress(): string;
    private _clone?;
    /**
     * @stability stable
     */
    get clone(): SqlDatabaseInstanceClone[];
    /**
     * @stability stable
     */
    set clone(value: SqlDatabaseInstanceClone[]);
    /**
     * @stability stable
     */
    resetClone(): void;
    /**
     * @stability stable
     */
    get cloneInput(): SqlDatabaseInstanceClone[] | undefined;
    private _replicaConfiguration?;
    /**
     * @stability stable
     */
    get replicaConfiguration(): SqlDatabaseInstanceReplicaConfiguration[];
    /**
     * @stability stable
     */
    set replicaConfiguration(value: SqlDatabaseInstanceReplicaConfiguration[]);
    /**
     * @stability stable
     */
    resetReplicaConfiguration(): void;
    /**
     * @stability stable
     */
    get replicaConfigurationInput(): SqlDatabaseInstanceReplicaConfiguration[] | undefined;
    private _restoreBackupContext?;
    /**
     * @stability stable
     */
    get restoreBackupContext(): SqlDatabaseInstanceRestoreBackupContext[];
    /**
     * @stability stable
     */
    set restoreBackupContext(value: SqlDatabaseInstanceRestoreBackupContext[]);
    /**
     * @stability stable
     */
    resetRestoreBackupContext(): void;
    /**
     * @stability stable
     */
    get restoreBackupContextInput(): SqlDatabaseInstanceRestoreBackupContext[] | undefined;
    private _settings?;
    /**
     * @stability stable
     */
    get settings(): SqlDatabaseInstanceSettings[];
    /**
     * @stability stable
     */
    set settings(value: SqlDatabaseInstanceSettings[]);
    /**
     * @stability stable
     */
    resetSettings(): void;
    /**
     * @stability stable
     */
    get settingsInput(): SqlDatabaseInstanceSettings[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): SqlDatabaseInstanceTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: SqlDatabaseInstanceTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SqlDatabaseInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
