import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TagsTagValueIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_binding.html#members TagsTagValueIamBinding#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_binding.html#role TagsTagValueIamBinding#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_binding.html#tag_value TagsTagValueIamBinding#tag_value}.
     *
     * @stability stable
     */
    readonly tagValue: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_binding.html#condition TagsTagValueIamBinding#condition}
     *
     * @stability stable
     */
    readonly condition?: TagsTagValueIamBindingCondition[];
}
/**
 * @stability stable
 */
export interface TagsTagValueIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_binding.html#description TagsTagValueIamBinding#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_binding.html#expression TagsTagValueIamBinding#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_binding.html#title TagsTagValueIamBinding#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_binding.html google_tags_tag_value_iam_binding}.
 *
 * @stability stable
 */
export declare class TagsTagValueIamBinding extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value_iam_binding.html google_tags_tag_value_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TagsTagValueIamBindingConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _members;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    get membersInput(): string[];
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _tagValue;
    /**
     * @stability stable
     */
    get tagValue(): string;
    /**
     * @stability stable
     */
    set tagValue(value: string);
    /**
     * @stability stable
     */
    get tagValueInput(): string;
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): TagsTagValueIamBindingCondition[];
    /**
     * @stability stable
     */
    set condition(value: TagsTagValueIamBindingCondition[]);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): TagsTagValueIamBindingCondition[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
