import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpcAccessConnectorConfig extends cdktf.TerraformMetaArguments {
    /**
     * The range of internal addresses that follows RFC 4632 notation. Example: '10.132.0.0/28'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html#ip_cidr_range VpcAccessConnector#ip_cidr_range}
     *
     * @stability stable
     */
    readonly ipCidrRange?: string;
    /**
     * Maximum throughput of the connector in Mbps, must be greater than 'min_throughput'. Default is 300.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html#max_throughput VpcAccessConnector#max_throughput}
     *
     * @stability stable
     */
    readonly maxThroughput?: number;
    /**
     * Minimum throughput of the connector in Mbps. Default and min is 200.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html#min_throughput VpcAccessConnector#min_throughput}
     *
     * @stability stable
     */
    readonly minThroughput?: number;
    /**
     * The name of the resource (Max 25 characters).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html#name VpcAccessConnector#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of the VPC network. Required if 'ip_cidr_range' is set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html#network VpcAccessConnector#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html#project VpcAccessConnector#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where the VPC Access connector resides. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html#region VpcAccessConnector#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html#timeouts VpcAccessConnector#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpcAccessConnectorTimeouts;
}
/**
 * @stability stable
 */
export interface VpcAccessConnectorTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html#create VpcAccessConnector#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html#delete VpcAccessConnector#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html google_vpc_access_connector}.
 *
 * @stability stable
 */
export declare class VpcAccessConnector extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/vpc_access_connector.html google_vpc_access_connector} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpcAccessConnectorConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _ipCidrRange?;
    /**
     * @stability stable
     */
    get ipCidrRange(): string;
    /**
     * @stability stable
     */
    set ipCidrRange(value: string);
    /**
     * @stability stable
     */
    resetIpCidrRange(): void;
    /**
     * @stability stable
     */
    get ipCidrRangeInput(): string | undefined;
    private _maxThroughput?;
    /**
     * @stability stable
     */
    get maxThroughput(): number;
    /**
     * @stability stable
     */
    set maxThroughput(value: number);
    /**
     * @stability stable
     */
    resetMaxThroughput(): void;
    /**
     * @stability stable
     */
    get maxThroughputInput(): number | undefined;
    private _minThroughput?;
    /**
     * @stability stable
     */
    get minThroughput(): number;
    /**
     * @stability stable
     */
    set minThroughput(value: number);
    /**
     * @stability stable
     */
    resetMinThroughput(): void;
    /**
     * @stability stable
     */
    get minThroughputInput(): number | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get state(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): VpcAccessConnectorTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: VpcAccessConnectorTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpcAccessConnectorTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
