# Generated by Django 3.2 on 2021-10-20 00:20

from django.db import migrations, models
import django.db.models.deletion
import modelcluster.fields
import wagtail.contrib.routable_page.models
import wagtail.core.fields
import wagtail.search.index


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailcore', '0062_comment_models_and_pagesubscription'),
        ('wagtailperson', '0006_auto_20200416_1603'),
    ]

    operations = [
        migrations.CreateModel(
            name='ActivityLocation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='name')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('street', models.CharField(blank=True, max_length=255, verbose_name='street')),
                ('street_number', models.CharField(blank=True, max_length=5, verbose_name='street number')),
                ('zip', models.CharField(blank=True, max_length=255, verbose_name='zip')),
                ('city', models.CharField(blank=True, max_length=255, verbose_name='city')),
                ('country', models.CharField(blank=True, max_length=255, verbose_name='country')),
                ('floor', models.CharField(blank=True, max_length=255, verbose_name='floor')),
                ('OSM_url', models.URLField(blank=True, max_length=255, verbose_name='OpenStreetMap URL')),
            ],
            options={
                'verbose_name': 'Activity location',
                'verbose_name_plural': 'Activity locations',
                'ordering': ['name'],
            },
            bases=(wagtail.search.index.Indexed, models.Model),
        ),
        migrations.CreateModel(
            name='Agenda',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.page')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('archives_enabled', models.BooleanField(default=False, help_text='Each passed activities will be shown on a ./archives page', verbose_name='archives_enabled')),
            ],
            options={
                'verbose_name': 'Agenda',
                'verbose_name_plural': 'Agendas',
                'ordering': ['title'],
            },
            bases=(wagtail.contrib.routable_page.models.RoutablePageMixin, 'wagtailcore.page'),
        ),
        migrations.CreateModel(
            name='PublicTransportStop',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('name', models.CharField(max_length=255, verbose_name='type')),
                ('type', models.CharField(max_length=20, verbose_name='type')),
                ('line_number', models.CharField(max_length=20, verbose_name='line number')),
                ('location', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='public_transport_stops', to='wagtailagenda.activitylocation')),
            ],
            options={
                'verbose_name': 'Public Transport Stop',
                'verbose_name_plural': 'Public Transport Stops',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Activity',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.page')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('begin', models.DateTimeField(verbose_name='begin on')),
                ('end', models.DateTimeField(verbose_name='end on')),
                ('program', wagtail.core.fields.RichTextField(blank=True, null=True, verbose_name='program of the activity')),
                ('location', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='wagtailagenda.activitylocation', verbose_name='where')),
                ('organizers', models.ManyToManyField(to='wagtailperson.Person', verbose_name='organizers')),
            ],
            options={
                'verbose_name': 'Activity',
                'verbose_name_plural': 'Activities',
                'ordering': ['begin', 'end', 'title'],
            },
            bases=('wagtailcore.page',),
        ),
    ]
