import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The certificate body in PEM format. This attribute is immutable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate#certificate Certificate#certificate}
    */
    readonly certificate: string;
    /**
    * The certificate chain. This attribute is immutable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate#certificate_chain Certificate#certificate_chain}
    */
    readonly certificateChain?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate#id Certificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The certificate name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate#name Certificate#name}
    */
    readonly name: string;
    /**
    * The private key blob. This attribute is immutable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate#private_key Certificate#private_key}
    */
    readonly privateKey: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate#timeouts Certificate#timeouts}
    */
    readonly timeouts?: CertificateTimeouts;
}
export interface CertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate#create Certificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate#default Certificate#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate#delete Certificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate#update Certificate#update}
    */
    readonly update?: string;
}
export declare function certificateTimeoutsToTerraform(struct?: CertificateTimeoutsOutputReference | CertificateTimeouts | cdktf.IResolvable): any;
export declare class CertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CertificateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate ionoscloud_certificate}
*/
export declare class Certificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/certificate ionoscloud_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CertificateConfig
    */
    constructor(scope: Construct, id: string, config: CertificateConfig);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    get certificateInput(): string | undefined;
    private _certificateChain?;
    get certificateChain(): string;
    set certificateChain(value: string);
    resetCertificateChain(): void;
    get certificateChainInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    private _timeouts;
    get timeouts(): CertificateTimeoutsOutputReference;
    putTimeouts(value: CertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
