import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MongoUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#cluster_id MongoUser#cluster_id}
    */
    readonly clusterId: string;
    /**
    * The user database to use for authentication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#database MongoUser#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#id MongoUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#password MongoUser#password}
    */
    readonly password: string;
    /**
    * The user database uses for authentication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#username MongoUser#username}
    */
    readonly username: string;
    /**
    * roles block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#roles MongoUser#roles}
    */
    readonly roles?: MongoUserRoles[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#timeouts MongoUser#timeouts}
    */
    readonly timeouts?: MongoUserTimeouts;
}
export interface MongoUserRoles {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#database MongoUser#database}
    */
    readonly database?: string;
    /**
    * A list of mongodb user roles. Examples: read, readWrite, readAnyDatabase
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#role MongoUser#role}
    */
    readonly role?: string;
}
export declare function mongoUserRolesToTerraform(struct?: MongoUserRoles | cdktf.IResolvable): any;
export declare class MongoUserRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MongoUserRoles | cdktf.IResolvable | undefined;
    set internalValue(value: MongoUserRoles | cdktf.IResolvable | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
}
export declare class MongoUserRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MongoUserRoles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MongoUserRolesOutputReference;
}
export interface MongoUserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#create MongoUser#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#default MongoUser#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#delete MongoUser#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user#update MongoUser#update}
    */
    readonly update?: string;
}
export declare function mongoUserTimeoutsToTerraform(struct?: MongoUserTimeoutsOutputReference | MongoUserTimeouts | cdktf.IResolvable): any;
export declare class MongoUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MongoUserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MongoUserTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user ionoscloud_mongo_user}
*/
export declare class MongoUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_mongo_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/mongo_user ionoscloud_mongo_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MongoUserConfig
    */
    constructor(scope: Construct, id: string, config: MongoUserConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _roles;
    get roles(): MongoUserRolesList;
    putRoles(value: MongoUserRoles[] | cdktf.IResolvable): void;
    resetRoles(): void;
    get rolesInput(): cdktf.IResolvable | MongoUserRoles[] | undefined;
    private _timeouts;
    get timeouts(): MongoUserTimeoutsOutputReference;
    putTimeouts(value: MongoUserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MongoUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
