```
usage: yawp [-h] [-H] [-V] [-v] [-s] [-N] [-U] [-g] [-p] [-w CHARS_PER_LINE]
            [-l] [-c CONTENTS_TITLE] [-i INDEX_TITLE] [-f] [-F] [-e EVEN_LEFT]
            [-E EVEN_RIGHT] [-o ODD_LEFT] [-O ODD_RIGHT] [-a] [-P FILE_PDF]
            [-W CHAR_WIDTH] [-A CHAR_ASPECT] [-S PAPER_SIZE] [-Z]
            [-L LEFT_MARGIN] [-R RIGHT_MARGIN] [-T TOP_MARGIN]
            [-B BOTTOM_MARGIN] [-C]
            [file]

Yet Another Word Processor, an automatic word processor for text files, with PDF output

                       I sound my barbaric yawp over the roofs of the world

                                                               Walt Whitman

The  name  "yawp"  here  means  Yet  Another Word Processor, and yawp is an
automatic  word  processor  for  plain  text files, with PDF output. If you
really  need  all  the features of a full-fledged WYSIWYG word processor as
LibreOffice  Writer,  yawp is not for you. But if you just want to create a
simple quick-and-dirty no-frills document, with yawp you can:

    • edit a text file by your favorite editor
    • run yawp in order to:
        • backup read format and rewrite the text file
        • export the text file in a PDF file
        • open the PDF file for check or print
    • possibly go back to the editor and update the text file, or finish

                                              ┌───────┐
                                              │backup │
                                              │       │
                                              │ file  │
                                              └─────┬─┘
                                                △   │
                                                │   │restore
                                                │   │ (undo)
                                          backup│   │
                                                │   │
                                                │   ▽
    ┌───────────┐                           ┌───┴───────┐
    │           │         ┌───────┐  read   │           │         ┌───────┐
    │           │  edit   │ text  ├────────▷│           │ export  │ PDF   │
    │  editor   ├────────▷│       │         │   yawp    ├────────▷│       │
    │           │         │ file  │◁────────┤           │         │ file  │
    │           │         └───────┘ rewrite │           │         └───┬───┘
    └───────────┘                           └───────────┘             │
          △                                                           │
          │                          check                            │
          └───────────────────────────────────────────────────────────┘

Main features are:

    • yawp  processes  in place a single text file, hereinafter referred to
      simply as the "file"
    • yawp  before  processing  makes  a  timestamped  backup  of the file,
      allowing undo operation
    • yawp  processing  is  driven by the text in the file and by arguments
      only, not by commands or tags embedded in text
    • yawp justifies text at left and right in:
        • unindented paragraphs
        • dot-marked indented paragraphs (as this one)
    • yawp  accepts  unjustified  pictures  (as  schemas,  tables  and code
      examples) freely intermixed with text
    • yawp  adopts  an  ad  hoc  policy  for  Python  files, formatting the
      docstrings but not the Python code
    • yawp  performs  multi-level  chapter  renumbering
    • yawp  inserts  an  automatic  contents chapter in the file
    • yawp  recognizes  relevant  subjects  (quoted  by '"') and inserts an
      automatic index chapter in the file
    • yawp cuts the file in pages, by automatic insertion of two-lines page
      headers
    • yawp  also  has some limited graphic feature, you can sketch pictures
      with  segments (by '`') and arrowheads (by '^'), yawp redraws them by
      proper   graphic  characters  (as  in  the  picture  above)
    • yawp  exports  the  resulting  lines in PDF format, with control over
      character  size  and page layout, and opens for you the generated PDF
      file, allowing preview and printing
    • yawp  corrects  errors  made  by  CUPS-PDF  about  font size and page
      margins, you can use default corrections or redefine them by yawp.cfg
    • yawp is "stable", namely if after a yawp execution you run yawp again
      on  the  same  file with the same arguments, the file content doesn't
      change (except date and time in page headers)

Everything has been kept as simple as possible.

In order to install yawp, type:

    │ $ sudo apt-get -y update
    │ $ sudo apt-get -y install printer-driver-cups-pdf

If you don't have pip, type:

    │ $ sudo apt-get -y install python3-pip

If you type at terminal:

    │ $ pip3 install --upgrade yawp

this command will:

    • install current version of yawp if not present
    • upgrade yawp to the current version if already installed

If you see a message like this:

    │ WARNING: The script yawp is installed in ... which is not on PATH.

don't worry, a reboot should fix the problem.

For any detail, see the yawp-generated "yawp manual" by typing:

    │ $ yawp -H

positional arguments:
  file                  text file to be processed

optional arguments:
  -h, --help            show this help message and exit
  -H, --manual          open yawp-generated PDF manual and exit
  -V, --version         show program's version number and exit
  -v, --verbose         display information messages on stderr
  -s, --echo-shell      display invoked Unix commands on stderr
  -N, --no-format       backup but don't format (default: backup and format)
  -U, --undo            restore the file from last backup (default: backup and
                        format)
  -g, --graphics        redraw '`'-segments and '^'-arrowheads
  -p, --print-file      at end print file on stdout
  -w CHARS_PER_LINE, --chars-per-line CHARS_PER_LINE
                        line width in characters per line (default: '0' =
                        automatic)
  -l, --left-only       justify text lines at left only (default: at left and
                        right)
  -c CONTENTS_TITLE, --contents-title CONTENTS_TITLE
                        title of contents chapter (default: 'contents')
  -i INDEX_TITLE, --index-title INDEX_TITLE
                        title of index chapter (default: 'index')
  -f, --form-feed       insert page headers on full page
  -F, --form-feed-chap  insert page headers on full page and before contents
                        index and level-one chapters
  -e EVEN_LEFT, --even-left EVEN_LEFT
                        headers of even pages, left (default: '%n/%N')
  -E EVEN_RIGHT, --even-right EVEN_RIGHT
                        headers of even pages, right (default: '%f.%e %Y-%m-%d
                        %H:%M:%S')
  -o ODD_LEFT, --odd-left ODD_LEFT
                        headers of odd pages, left (default: '%c')
  -O ODD_RIGHT, --odd-right ODD_RIGHT
                        headers of odd pages, right (default: '%n/%N')
  -a, --all-pages-E-e   put in all page headers -E at left and -e at right
  -P FILE_PDF, --file-pdf FILE_PDF
                        at end export and open this PDF file ('0' = no export,
                        default: '%P/%f.pdf')
  -W CHAR_WIDTH, --char-width CHAR_WIDTH
                        character width (pt/in/mm/cm, default: '0' =
                        automatic)
  -A CHAR_ASPECT, --char-aspect CHAR_ASPECT
                        character aspect ratio = char width / char height ('1'
                        = square grid, default: '3/5')
  -S PAPER_SIZE, --paper-size PAPER_SIZE
                        portrait paper size (width x height, pt/in/mm/cm,
                        default: 'A4' = '210x297mm'
  -Z, --landscape       turn page by 90 degrees (default: portrait)
  -L LEFT_MARGIN, --left-margin LEFT_MARGIN
                        left margin (pt/in/mm/cm, default: '2cm')
  -R RIGHT_MARGIN, --right-margin RIGHT_MARGIN
                        right margin (pt/in/mm/cm, default: '-L')
  -T TOP_MARGIN, --top-margin TOP_MARGIN
                        top margin (pt/in/mm/cm, default: '2cm')
  -B BOTTOM_MARGIN, --bottom-margin BOTTOM_MARGIN
                        bottom margin (pt/in/mm/cm, default: '-T')
  -C, --calibration     don't correct character size and page margins
```
