from typing import Any, Dict, List, Optional, AsyncGenerator, TypeVar

T = TypeVar('T')

# Stub classes for MCPClient, MCPAgent, and LangChainAdapter
class MCPClient:
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def add_server(self, name: str, server_config: Dict[str, Any]) -> None: ...
    def remove_server(self, name: str) -> None: ...
    def get_server_names(self) -> List[str]: ...
    def save_config(self, filepath: str) -> None: ...
    async def close_session(self, server_name: str) -> None: ...
    def get_all_active_sessions(self) -> Dict[str, Any]: ...
    async def create_session(self, server_name: str, auto_initialize: bool = True) -> Any: ...
    async def create_all_sessions(self, auto_initialize: bool = True) -> Dict[str, Any]: ...

class MCPAgent:
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    async def run(self, message: str, **kwargs: Any) -> str: ...
    def stream(self, query: str, **kwargs: Any) -> AsyncGenerator[Any, None]: ...
    async def initialize(self) -> None: ...
    async def close(self) -> None: ...
    def get_conversation_history(self) -> List[Any]: ...
    def clear_conversation_history(self) -> None: ...
    def add_to_history(self, message: Any) -> None: ...
    def get_system_message(self) -> Optional[Any]: ...
    def set_system_message(self, message: str) -> None: ...
    def set_disallowed_tools(self, disallowed_tools: List[str]) -> None: ...
    def get_disallowed_tools(self) -> List[str]: ...

class LangChainAdapter:
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def create_tools(self, client: Any, allowed_tools: Optional[List[str]] = None, disallowed_tools: Optional[List[str]] = None) -> List[Any]: ...
    def _convert_tool(self, tool_info: Dict[str, Any], server_name: str) -> Any: ...
    def _create_tools_from_connectors(self, connectors: List[Any]) -> List[Any]: ...