# coding: utf-8

"""
    COIN Number Portability API V3

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 3.0.0
    Contact: servicedesk@coin.nl
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re

import six


class PortingRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'dossierid': 'str',
        'recipientserviceprovider': 'str',
        'recipientnetworkoperator': 'str',
        'donornetworkoperator': 'str',
        'donorserviceprovider': 'str',
        'customerinfo': 'CustomerInfo',
        'contract': 'str',
        'note': 'str',
        'repeats': 'list[PortingRequestRepeats]'
    }

    attribute_map = {
        'dossierid': 'dossierid',
        'recipientserviceprovider': 'recipientserviceprovider',
        'recipientnetworkoperator': 'recipientnetworkoperator',
        'donornetworkoperator': 'donornetworkoperator',
        'donorserviceprovider': 'donorserviceprovider',
        'customerinfo': 'customerinfo',
        'contract': 'contract',
        'note': 'note',
        'repeats': 'repeats'
    }

    def __init__(self, dossierid=None, recipientserviceprovider=None, recipientnetworkoperator=None, donornetworkoperator=None, donorserviceprovider=None, customerinfo=None, contract=None, note=None, repeats=None):
        """PortingRequest - a model defined in Swagger"""
        self._dossierid = None
        self._recipientserviceprovider = None
        self._recipientnetworkoperator = None
        self._donornetworkoperator = None
        self._donorserviceprovider = None
        self._customerinfo = None
        self._contract = None
        self._note = None
        self._repeats = None
        self.discriminator = None
        self.dossierid = dossierid
        if recipientserviceprovider is not None:
            self.recipientserviceprovider = recipientserviceprovider
        self.recipientnetworkoperator = recipientnetworkoperator
        if donornetworkoperator is not None:
            self.donornetworkoperator = donornetworkoperator
        if donorserviceprovider is not None:
            self.donorserviceprovider = donorserviceprovider
        if customerinfo is not None:
            self.customerinfo = customerinfo
        if contract is not None:
            self.contract = contract
        if note is not None:
            self.note = note
        self.repeats = repeats

    @property
    def dossierid(self):
        """Gets the dossierid of this PortingRequest.


        :return: The dossierid of this PortingRequest.
        :rtype: str
        """
        return self._dossierid

    @dossierid.setter
    def dossierid(self, dossierid):
        """Sets the dossierid of this PortingRequest.


        :param dossierid: The dossierid of this PortingRequest.
        :type: str
        """
        if dossierid is None:
            raise ValueError("Invalid value for `dossierid`, must not be `None`")
        if dossierid is not None and not re.search(r'[-0-9A-Z]{5,26}', dossierid):
            raise ValueError(r"Invalid value for `dossierid`, must be a follow pattern or equal to `/[-0-9A-Z]{5,26}/`")

        self._dossierid = dossierid

    @property
    def recipientserviceprovider(self):
        """Gets the recipientserviceprovider of this PortingRequest.


        :return: The recipientserviceprovider of this PortingRequest.
        :rtype: str
        """
        return self._recipientserviceprovider

    @recipientserviceprovider.setter
    def recipientserviceprovider(self, recipientserviceprovider):
        """Sets the recipientserviceprovider of this PortingRequest.


        :param recipientserviceprovider: The recipientserviceprovider of this PortingRequest.
        :type: str
        """
        if recipientserviceprovider is not None and not re.search(r'[0-9A-Z]{3,6}', recipientserviceprovider):  # noqa: E501
            raise ValueError(r"Invalid value for `recipientserviceprovider`, must be a follow pattern or equal to `/[0-9A-Z]{3,6}/`")  # noqa: E501

        self._recipientserviceprovider = recipientserviceprovider

    @property
    def recipientnetworkoperator(self):
        """Gets the recipientnetworkoperator of this PortingRequest.


        :return: The recipientnetworkoperator of this PortingRequest.
        :rtype: str
        """
        return self._recipientnetworkoperator

    @recipientnetworkoperator.setter
    def recipientnetworkoperator(self, recipientnetworkoperator):
        """Sets the recipientnetworkoperator of this PortingRequest.


        :param recipientnetworkoperator: The recipientnetworkoperator of this PortingRequest.
        :type: str
        """
        if recipientnetworkoperator is None:
            raise ValueError("Invalid value for `recipientnetworkoperator`, must not be `None`")  # noqa: E501
        if recipientnetworkoperator is not None and not re.search(r'[0-9A-Z]{3,6}', recipientnetworkoperator):  # noqa: E501
            raise ValueError(r"Invalid value for `recipientnetworkoperator`, must be a follow pattern or equal to `/[0-9A-Z]{3,6}/`")  # noqa: E501

        self._recipientnetworkoperator = recipientnetworkoperator

    @property
    def donornetworkoperator(self):
        """Gets the donornetworkoperator of this PortingRequest.


        :return: The donornetworkoperator of this PortingRequest.
        :rtype: str
        """
        return self._donornetworkoperator

    @donornetworkoperator.setter
    def donornetworkoperator(self, donornetworkoperator):
        """Sets the donornetworkoperator of this PortingRequest.


        :param donornetworkoperator: The donornetworkoperator of this PortingRequest.
        :type: str
        """
        if donornetworkoperator is not None and not re.search(r'[0-9A-Z]{3,6}', donornetworkoperator):  # noqa: E501
            raise ValueError(r"Invalid value for `donornetworkoperator`, must be a follow pattern or equal to `/[0-9A-Z]{3,6}/`")  # noqa: E501

        self._donornetworkoperator = donornetworkoperator

    @property
    def donorserviceprovider(self):
        """Gets the donorserviceprovider of this PortingRequest.


        :return: The donorserviceprovider of this PortingRequest.
        :rtype: str
        """
        return self._donorserviceprovider

    @donorserviceprovider.setter
    def donorserviceprovider(self, donorserviceprovider):
        """Sets the donorserviceprovider of this PortingRequest.


        :param donorserviceprovider: The donorserviceprovider of this PortingRequest.
        :type: str
        """
        if donorserviceprovider is not None and not re.search(r'[0-9A-Z]{3,6}', donorserviceprovider):  # noqa: E501
            raise ValueError(r"Invalid value for `donorserviceprovider`, must be a follow pattern or equal to `/[0-9A-Z]{3,6}/`")  # noqa: E501

        self._donorserviceprovider = donorserviceprovider

    @property
    def customerinfo(self):
        """Gets the customerinfo of this PortingRequest.


        :return: The customerinfo of this PortingRequest.
        :rtype: CustomerInfo
        """
        return self._customerinfo

    @customerinfo.setter
    def customerinfo(self, customerinfo):
        """Sets the customerinfo of this PortingRequest.


        :param customerinfo: The customerinfo of this PortingRequest.
        :type: CustomerInfo
        """

        self._customerinfo = customerinfo

    @property
    def contract(self):
        """Gets the contract of this PortingRequest.


        :return: The contract of this PortingRequest.
        :rtype: str
        """
        return self._contract

    @contract.setter
    def contract(self, contract):
        """Sets the contract of this PortingRequest.


        :param contract: The contract of this PortingRequest.
        :type: str
        """

        if contract is not None and not re.search(r'^(EARLY_TERMINATION|CONTINUATION)$', contract):
            raise ValueError(r"Invalid value for `contract`, must be `EARLY_TERMINATION` or `CONTINUATION`")

        self._contract = contract

    @property
    def note(self):
        """Gets the note of this PortingRequest.


        :return: The note of this PortingRequest.
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note):
        """Sets the note of this PortingRequest.


        :param note: The note of this PortingRequest.
        :type: str
        """
        if note is not None and len(note) > 100:
            raise ValueError("Invalid value for `note`, length must be less than or equal to `100`")  # noqa: E501
        if note is not None and len(note) < 1:
            raise ValueError("Invalid value for `note`, length must be greater than or equal to `1`")  # noqa: E501

        self._note = note

    @property
    def repeats(self):
        """Gets the repeats of this PortingRequest.


        :return: The repeats of this PortingRequest.
        :rtype: list[PortingRequestRepeats]
        """
        return self._repeats

    @repeats.setter
    def repeats(self, repeats):
        """Sets the repeats of this PortingRequest.


        :param repeats: The repeats of this PortingRequest.
        :type: list[PortingRequestRepeats]
        """
        if repeats is None:
            raise ValueError("Invalid value for `repeats`, must not be `None`")

        self._repeats = repeats

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PortingRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PortingRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
