import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudIpblockConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#id DataIonoscloudIpblock#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#location DataIonoscloudIpblock#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#name DataIonoscloudIpblock#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#size DataIonoscloudIpblock#size}
    */
    readonly size?: number;
    /**
    * ip_consumers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#ip_consumers DataIonoscloudIpblock#ip_consumers}
    */
    readonly ipConsumers?: DataIonoscloudIpblockIpConsumers[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#timeouts DataIonoscloudIpblock#timeouts}
    */
    readonly timeouts?: DataIonoscloudIpblockTimeouts;
}
export interface DataIonoscloudIpblockIpConsumers {
}
export declare function dataIonoscloudIpblockIpConsumersToTerraform(struct?: DataIonoscloudIpblockIpConsumers | cdktf.IResolvable): any;
export declare class DataIonoscloudIpblockIpConsumersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudIpblockIpConsumers | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudIpblockIpConsumers | cdktf.IResolvable | undefined);
    get datacenterId(): string;
    get datacenterName(): string;
    get ip(): string;
    get k8SClusterUuid(): string;
    get k8SNodepoolUuid(): string;
    get mac(): string;
    get nicId(): string;
    get serverId(): string;
    get serverName(): string;
}
export declare class DataIonoscloudIpblockIpConsumersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataIonoscloudIpblockIpConsumers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudIpblockIpConsumersOutputReference;
}
export interface DataIonoscloudIpblockTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#create DataIonoscloudIpblock#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#default DataIonoscloudIpblock#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#delete DataIonoscloudIpblock#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#update DataIonoscloudIpblock#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudIpblockTimeoutsToTerraform(struct?: DataIonoscloudIpblockTimeoutsOutputReference | DataIonoscloudIpblockTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudIpblockTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudIpblockTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudIpblockTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock ionoscloud_ipblock}
*/
export declare class DataIonoscloudIpblock extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_ipblock";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock ionoscloud_ipblock} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudIpblockConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudIpblockConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ips(): string[];
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _ipConsumers;
    get ipConsumers(): DataIonoscloudIpblockIpConsumersList;
    putIpConsumers(value: DataIonoscloudIpblockIpConsumers[] | cdktf.IResolvable): void;
    resetIpConsumers(): void;
    get ipConsumersInput(): cdktf.IResolvable | DataIonoscloudIpblockIpConsumers[] | undefined;
    private _timeouts;
    get timeouts(): DataIonoscloudIpblockTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudIpblockTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudIpblockTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-ionoscloud-ipblock.d.ts.map