import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#availability_zone Volume#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#backup_unit_id Volume#backup_unit_id}
    */
    readonly backupUnitId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#bus Volume#bus}
    */
    readonly bus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#datacenter_id Volume#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#disk_type Volume#disk_type}
    */
    readonly diskType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#id Volume#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#image_name Volume#image_name}
    */
    readonly imageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#image_password Volume#image_password}
    */
    readonly imagePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#licence_type Volume#licence_type}
    */
    readonly licenceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#name Volume#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#server_id Volume#server_id}
    */
    readonly serverId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#size Volume#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#ssh_key_path Volume#ssh_key_path}
    */
    readonly sshKeyPath?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#user_data Volume#user_data}
    */
    readonly userData?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#timeouts Volume#timeouts}
    */
    readonly timeouts?: VolumeTimeouts;
}
export interface VolumeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#create Volume#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#default Volume#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#delete Volume#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume#update Volume#update}
    */
    readonly update?: string;
}
export declare function volumeTimeoutsToTerraform(struct?: VolumeTimeoutsOutputReference | VolumeTimeouts | cdktf.IResolvable): any;
export declare class VolumeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VolumeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VolumeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume ionoscloud_volume}
*/
export declare class Volume extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_volume";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/volume ionoscloud_volume} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VolumeConfig
    */
    constructor(scope: Construct, id: string, config: VolumeConfig);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    private _backupUnitId?;
    get backupUnitId(): string;
    set backupUnitId(value: string);
    resetBackupUnitId(): void;
    get backupUnitIdInput(): string | undefined;
    get bootServer(): string;
    private _bus?;
    get bus(): string;
    set bus(value: string);
    resetBus(): void;
    get busInput(): string | undefined;
    get cpuHotPlug(): cdktf.IResolvable;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    get deviceNumber(): number;
    get discVirtioHotPlug(): cdktf.IResolvable;
    get discVirtioHotUnplug(): cdktf.IResolvable;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    get diskTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get image(): string;
    get imageId(): string;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    resetImageName(): void;
    get imageNameInput(): string | undefined;
    private _imagePassword?;
    get imagePassword(): string;
    set imagePassword(value: string);
    resetImagePassword(): void;
    get imagePasswordInput(): string | undefined;
    private _licenceType?;
    get licenceType(): string;
    set licenceType(value: string);
    resetLicenceType(): void;
    get licenceTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get nicHotPlug(): cdktf.IResolvable;
    get nicHotUnplug(): cdktf.IResolvable;
    get pciSlot(): number;
    get ramHotPlug(): cdktf.IResolvable;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    private _sshKeyPath?;
    get sshKeyPath(): string[];
    set sshKeyPath(value: string[]);
    resetSshKeyPath(): void;
    get sshKeyPathInput(): string[] | undefined;
    get sshkey(): string;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _timeouts;
    get timeouts(): VolumeTimeoutsOutputReference;
    putTimeouts(value: VolumeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VolumeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=volume.d.ts.map