import { aws_sso, Resource, Tag } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { BastionAccessPolicyProps } from './access-policy';
export interface BastionPermissionSetProps extends aws_sso.CfnPermissionSetProps, BastionAccessPolicyProps {
}
export declare class BastionPermissionSet extends Resource {
    private policy;
    private permissionSet;
    private ssoInstanceArn;
    securityTag: Tag;
    constructor(scope: Construct, id: string, props: BastionPermissionSetProps);
    assign(accountId: string, principalId: string, principalType: string): void;
}
