"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ttl = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class Ttl extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const ttl = props.ttl;
        const pollInterval = props.pollInterval
            ? props.pollInterval
            : aws_cdk_lib_1.Duration.hours(1);
        const ttlLambda = new aws_cdk_lib_1.aws_lambda.Function(this, 'TtlFunction', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            code: aws_cdk_lib_1.aws_lambda.Code.fromInline(`#!/bin/env python
import boto3
import os
import time
import logging

log = logging.Logger("logger")
log.setLevel("INFO")

def handler(event, context):
    print(event)

    stack_name = os.environ['STACK_NAME']
    ttl = int(os.environ['TTL'])
    cfn = boto3.client('cloudformation')

    print(
        f"""
        StackName: {stack_name}
        TTL:       {ttl}
        """
    )

    stack = cfn.describe_stacks(StackName=stack_name)
    creation_time = stack['Stacks'][0]['CreationTime']
    creation_time_epoch = int(time.mktime(creation_time.timetuple()))

    now = time.time()
    delta = now - creation_time_epoch
    print(
        f"""
        Now:           {now}
        Creation Time: {creation_time}
        Delta:         {delta}
        """
    )
    if delta > ttl:
        print(f"deleting stack: {stack_name}")
        cfn.delete_stack(StackName=stack_name)
        return

    print(f"not deleting stack yet, {delta} seconds remaining")
    return`),
            handler: 'index.handler',
            environment: {
                TTL: ttl.toSeconds().toString(),
                STACK_NAME: aws_cdk_lib_1.Fn.ref('AWS::StackName'),
            },
            role: new aws_cdk_lib_1.aws_iam.Role(this, 'TtlRole', {
                assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
                managedPolicies: [
                    aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AdministratorAccess'),
                ],
            }),
            logRetention: 1,
        });
        new aws_cdk_lib_1.aws_events.Rule(this, 'IntervalSchedule', {
            schedule: aws_cdk_lib_1.aws_events.Schedule.rate(pollInterval),
            targets: [new aws_cdk_lib_1.aws_events_targets.LambdaFunction(ttlLambda)],
        });
    }
}
exports.Ttl = Ttl;
_a = JSII_RTTI_SYMBOL_1;
Ttl[_a] = { fqn: "pwed-cdk.ttl.Ttl", version: "0.0.66" };
//# sourceMappingURL=data:application/json;base64,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