<!-- markdownlint-disable MD033 MD041 -->
<p align="center">
  <img src="https://github.com/longchengguxiao/nonebot_plugin_xdu_support/blob/main/nonebot_plugin_xdu_support_logo.png" width="250" height="250" alt="nonebot_plugin_pvz">
</p>
<div align="center">

# nonebot_plugin_xdu_support

<!-- prettier-ignore-start -->
<!-- markdownlint-disable-next-line MD036 -->
_✨ 基于nonebot的XDU服务插件 ✨_
<!-- prettier-ignore-end -->

</div>

<p align="center">
    <a href="https://github.com/longchengguxiao/nonebot_plugin_xdu_support/blob/main/LICENSE">
    <img src="https://img.shields.io/github/license/longchengguxiao/nonebot_plugin_xdu_support" alt="license">
    </a>
    <a href="https://pypi.python.org/pypi/nonebot_plugin_xdu_support">
    <img src="https://img.shields.io/pypi/v/nonebot_plugin_xdu_support" alt="pypi">
    </a>
    <img src="https://img.shields.io/badge/python-3.8+-blue" alt="python">
</p>

## 说在前面

+ 请插件使用者仔细阅读此文档,确保能够正确理解命令。定时任务报错时会联系bot的superuser，因此一定要填好配置项才可以使用

+ 所有密码都经过**加密储存**，加密令牌可以[自定义](#自定义配置)，设置`DES_KEY`项。

+ 虽然对密码进行了加密处理，但是很遗憾，所有加密都是**可逆**的，如果不了解bot的主人请谨慎使用插件，**谨慎填写密码**。在进行功能订阅时可以回复'算了'或者'取消'来取消本次操作，或者在使用完功能后及时取消订阅该功能，以免造成不必要的损失

+ 请谨慎利用**记事本修改**数据保存的文件，这可能会导致插件运行出错

+ 对于插件问题可以提交issue或者pull_requests来进行交流

+ 对于本插件及本人下其他插件感兴趣的朋友可以添加QQ群聊（719392400）来对插件的发展给出建议以及测试

+ **用爱发电，请勿商用**

## 简介

Nonebot2插件，提供基础的西电校园服务，如课表提醒，体育打卡查询及提醒，晨午晚检打卡和马原测试等功能。

## 安装

```buildoutcfg
从 nb_cli 安装
python -m nb_cli plugin install nonebot_plugin_xdu_support

或从 PyPI 安装
python -m pip install nonebot_plugin_xdu_support
```

## 使用

```buildoutcfg
在bot.py 中添加nonebot.load_plugin("nonebot_plugin_xdu_support")

以及配置好nonebot_plugin_apscheduler,否则定时任务无法顺利执行
```
配置部分可以参考[nonebot文档](https://v2.nonebot.dev/docs/advanced/scheduler)

## 详细玩法

<details>
<summary>展开/收起</summary>

```buildoutcfg
通过使用关键字'xdu功能订阅'或'xdu服务订阅'来订阅插件功能

通过关键字'xdu取消订阅'或'xdu服务退订'来解除订阅插件功能

通过关键字'晨午晚检查看'或'查看晨午晚检'来主动查看当前时间段是否完成晨午晚检

通过关键字'体育打卡查看'或'查看体育打卡'来主动查看当前打卡次数

通过关键字'课表查询'或'课表查看'来主动查看当天课表

通过关键字'更新课表'来更新课表的本地缓存

通过关键字'马原'(+空格+'单选'/'多选')来获取一道单选或者多选题，不加参数则为随机获取
```

</details>

## 命令详解

<details>
<summary>展开/收起</summary>

|  命令  |  格式（逗号分割）  |  命令样例（不需要引号）  |  返回和解释  |
|  ----  |  ----  |  ----  |  ----  |
|  功能订阅  | xdu功能订阅，xdu服务订阅 | 'xdu功能订阅' | 后续会提示输入订阅的功能以及对应的账号密码，该功能仅私聊可用 |
|  功能退订  | xdu功能退订，xdu取消订阅 | 'xdu取消订阅' | 后续提示输入退订的功能，该功能私聊群聊均可用 |
|  晨午晚检  | 晨午晚检查看，查看晨午晚检 | '晨午晚检查看' | 主动返回当前时间段是否进行晨午晚检，订阅此服务即意味着每天的7,14,20点会进行一次打卡 |
|  体育打卡  | 体育打卡查看，查看体育打卡 | '体育打卡查看' | 主动返回当前时刻的体育打卡有效次数，订阅此服务意味着会在系统收到第一次体育打卡信息的时候提醒你还有多久第二次打卡 |
|  课表提醒  | 课表查询，课表查看 | '课表查询' | 主动返回当天课表，订阅此服务即每天晚上22点推送第二天课表，每节课提前30分钟提醒下节课的信息 |
|  马原测试  | 马原(+空格+单选/多选) | '马原 单选' | 返回单选或多选题一道，可以通过参数指定，默认为随机。在作答完题目后还会返回正确率 |

</details>


## 更新

<details>
<summary>展开/收起</summary>

### v0.1.6

+ 2023/01/28 使用暂无问题，修复了mknod报错

### v0.1.0

+ 2023/01/28 基础功能基本实现，选课模块以及体育打卡补缺提上日程

</details>

## 自定义配置

```buildoutcfg
对Python编程比较熟悉的使用者可以在 .env 文件中设置XDU_SUPPORT_PATH来选择存储位置，不设置即为默认位置

设置 DES_KEY 来更改加密秘钥，但要注意必须是8位的字符串，否则无法正常运行
```

## 特别感谢

感谢 [libxduauth](https://github.com/xdlinux/libxduauth) 项目提供模拟登陆

感谢 [xd_script](https://github.com/xdlinux/xidian-scripts) 项目提供参考，部分代码转化/改写自其中的脚本
