import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [globalaccelerator](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsglobalaccelerator.html).
 *
 * @experimental
 */
export declare class Globalaccelerator extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [globalaccelerator](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsglobalaccelerator.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to add a virtual private cloud (VPC) subnet endpoint to a custom routing accelerator endpoint group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_AddCustomRoutingEndpoints.html
     *
     * @experimental
     */
    toAddCustomRoutingEndpoints(): this;
    /**
     * (experimental) Grants permission to advertises an IPv4 address range that is provisioned for use with your accelerator through bring your own IP addresses (BYOIP).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_AdvertiseByoipCidr.html
     *
     * @experimental
     */
    toAdvertiseByoipCidr(): this;
    /**
     * (experimental) Grants permission to allows custom routing of user traffic to a private destination IP:PORT in a specific VPC subnet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html
     *
     * @experimental
     */
    toAllowCustomRoutingTraffic(): this;
    /**
     * (experimental) Grants permission to create a standard accelerator.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateAccelerator.html
     *
     * @experimental
     */
    toCreateAccelerator(): this;
    /**
     * (experimental) Grants permission to create a Custom Routing accelerator.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateCustomRoutingAccelerator.html
     *
     * @experimental
     */
    toCreateCustomRoutingAccelerator(): this;
    /**
     * (experimental) Grants permission to create an endpoint group for the specified listener for a custom routing accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateCustomRoutingEndpointGroup.html
     *
     * @experimental
     */
    toCreateCustomRoutingEndpointGroup(): this;
    /**
     * (experimental) Grants permission to create a listener to process inbound connections from clients to a custom routing accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateCustomRoutingListener.html
     *
     * @experimental
     */
    toCreateCustomRoutingListener(): this;
    /**
     * (experimental) Grants permission to add an endpoint group to a standard accelerator listener.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateEndpointGroup.html
     *
     * @experimental
     */
    toCreateEndpointGroup(): this;
    /**
     * (experimental) Grants permission to add a listener to a standard accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateListener.html
     *
     * @experimental
     */
    toCreateListener(): this;
    /**
     * (experimental) Grants permission to delete a standard accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteAccelerator.html
     *
     * @experimental
     */
    toDeleteAccelerator(): this;
    /**
     * (experimental) Grants permission to delete a custom routing accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteCustomRoutingAccelerator.html
     *
     * @experimental
     */
    toDeleteCustomRoutingAccelerator(): this;
    /**
     * (experimental) Grants permission to delete an endpoint group from a listener for a custom routing accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteCustomRoutingEndpointGroup.html
     *
     * @experimental
     */
    toDeleteCustomRoutingEndpointGroup(): this;
    /**
     * (experimental) Grants permission to delete a listener for a custom routing accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteCustomRoutingListener.html
     *
     * @experimental
     */
    toDeleteCustomRoutingListener(): this;
    /**
     * (experimental) Grants permission to delete an endpoint group associated with a standard accelerator listener.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteEndpointGroup.html
     *
     * @experimental
     */
    toDeleteEndpointGroup(): this;
    /**
     * (experimental) Grants permission to delete a listener from a standard accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteListener.html
     *
     * @experimental
     */
    toDeleteListener(): this;
    /**
     * (experimental) Grants permission to disallows custom routing of user traffic to a private destination IP:PORT in a specific VPC subnet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DenyCustomRoutingTraffic.html
     *
     * @experimental
     */
    toDenyCustomRoutingTraffic(): this;
    /**
     * (experimental) Grants permission to releases the specified address range that you provisioned for use with your accelerator through bring your own IP addresses (BYOIP).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeprovisionByoipCidr.html
     *
     * @experimental
     */
    toDeprovisionByoipCidr(): this;
    /**
     * (experimental) Grants permissions to describe a standard accelerator.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeAccelerator.html
     *
     * @experimental
     */
    toDescribeAccelerator(): this;
    /**
     * (experimental) Grants permission to describe a standard accelerator attributes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeAcceleratorAttributes.html
     *
     * @experimental
     */
    toDescribeAcceleratorAttributes(): this;
    /**
     * (experimental) Grants permission to describe a custom routing accelerator.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeCustomRoutingAccelerator.html
     *
     * @experimental
     */
    toDescribeCustomRoutingAccelerator(): this;
    /**
     * (experimental) Grants permission to describe the attributes of a custom routing accelerator.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeCustomRoutingAcceleratorAttributes.html
     *
     * @experimental
     */
    toDescribeCustomRoutingAcceleratorAttributes(): this;
    /**
     * (experimental) Grants permission to describe an endpoint group for a custom routing accelerator.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeCustomRoutingEndpointGroup.html
     *
     * @experimental
     */
    toDescribeCustomRoutingEndpointGroup(): this;
    /**
     * (experimental) Grants permission to describe a listener for a custom routing accelerator.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeCustomRoutingListener.html
     *
     * @experimental
     */
    toDescribeCustomRoutingListener(): this;
    /**
     * (experimental) Grants permission to describe a standard accelerator endpoint group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeEndpointGroup.html
     *
     * @experimental
     */
    toDescribeEndpointGroup(): this;
    /**
     * (experimental) Grants permission to describe a standard accelerator listener.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeListener.html
     *
     * @experimental
     */
    toDescribeListener(): this;
    /**
     * (experimental) Grants permission to list all standard accelerators.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListAccelerators.html
     *
     * @experimental
     */
    toListAccelerators(): this;
    /**
     * (experimental) Grants permission to list the BYOIP cidrs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListByoipCidrs.html
     *
     * @experimental
     */
    toListByoipCidrs(): this;
    /**
     * (experimental) Grants permission to list the custom routing accelerators for an AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListCustomRoutingAccelerators.html
     *
     * @experimental
     */
    toListCustomRoutingAccelerators(): this;
    /**
     * (experimental) Grants permission to list the endpoint groups that are associated with a listener for a custom routing accelerator.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListCustomRoutingEndpointGroups.html
     *
     * @experimental
     */
    toListCustomRoutingEndpointGroups(): this;
    /**
     * (experimental) Grants permission to list the listeners for a custom routing accelerator.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListCustomRoutingListeners.html
     *
     * @experimental
     */
    toListCustomRoutingListeners(): this;
    /**
     * (experimental) Grants permission to list the port mappings for a custom routing accelerator.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListCustomRoutingPortMappings.html
     *
     * @experimental
     */
    toListCustomRoutingPortMappings(): this;
    /**
     * (experimental) Grants permission to list the port mappings for a specific endpoint IP address (a destination address) in a subnet.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListCustomRoutingPortMappingsByDestination.html
     *
     * @experimental
     */
    toListCustomRoutingPortMappingsByDestination(): this;
    /**
     * (experimental) Grants permission to list all endpoint groups associated with a standard accelerator listener.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListEndpointGroups.html
     *
     * @experimental
     */
    toListEndpointGroups(): this;
    /**
     * (experimental) Grants permission to list all listeners associated with a standard accelerator.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListListeners.html
     *
     * @experimental
     */
    toListListeners(): this;
    /**
     * (experimental) Grants permission to list tags for a globalaccelerator resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to provisions an address range for use with your accelerator through bring your own IP addresses (BYOIP).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ProvisionByoipCidr.html
     *
     * @experimental
     */
    toProvisionByoipCidr(): this;
    /**
     * (experimental) Grants permission to remove virtual private cloud (VPC) subnet endpoints from a custom routing accelerator endpoint group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_RemoveCustomRoutingEndpoints.html
     *
     * @experimental
     */
    toRemoveCustomRoutingEndpoints(): this;
    /**
     * (experimental) Grants permission to add tags to a globalaccelerator resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a globalaccelerator resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a standard accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateAccelerator.html
     *
     * @experimental
     */
    toUpdateAccelerator(): this;
    /**
     * (experimental) Grants permission to update a standard accelerator attributes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateAcceleratorAttributes.html
     *
     * @experimental
     */
    toUpdateAcceleratorAttributes(): this;
    /**
     * (experimental) Grants permission to update a custom routing accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateCustomRoutingAccelerator.html
     *
     * @experimental
     */
    toUpdateCustomRoutingAccelerator(): this;
    /**
     * (experimental) Grants permission to update the attributes for a custom routing accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateCustomRoutingAcceleratorAttributes.html
     *
     * @experimental
     */
    toUpdateCustomRoutingAcceleratorAttributes(): this;
    /**
     * (experimental) Grants permission to update a listener for a custom routing accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateCustomRoutingListener.html
     *
     * @experimental
     */
    toUpdateCustomRoutingListener(): this;
    /**
     * (experimental) Grants permission to update an endpoint group on a standard accelerator listener.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html
     *
     * @experimental
     */
    toUpdateEndpointGroup(): this;
    /**
     * (experimental) Grants permission to update a listener on a standard accelerator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateListener.html
     *
     * @experimental
     */
    toUpdateListener(): this;
    /**
     * (experimental) Grants permission to stops advertising a BYOIP IPv4 address.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_WithdrawByoipCidr.html
     *
     * @experimental
     */
    toWithdrawByoipCidr(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type accelerator to the statement.
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_Accelerator.html
     *
     * @param acceleratorId - Identifier for the acceleratorId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAccelerator(acceleratorId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type listener to the statement.
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_Listener.html
     *
     * @param acceleratorId - Identifier for the acceleratorId.
     * @param listenerId - Identifier for the listenerId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onListener(acceleratorId: string, listenerId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type endpointgroup to the statement.
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_EndpointGroup.html
     *
     * @param acceleratorId - Identifier for the acceleratorId.
     * @param listenerId - Identifier for the listenerId.
     * @param endpointGroupId - Identifier for the endpointGroupId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEndpointgroup(acceleratorId: string, listenerId: string, endpointGroupId: string, account?: string, partition?: string): this;
}
