"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53domains = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
 *
 * @experimental
 */
class Route53domains extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'route53domains';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Read": [
                "CheckDomainAvailability",
                "GetContactReachabilityStatus",
                "GetDomainDetail",
                "GetDomainSuggestions",
                "GetOperationDetail",
                "ViewBilling"
            ],
            "Tagging": [
                "DeleteTagsForDomain",
                "UpdateTagsForDomain"
            ],
            "Write": [
                "DisableDomainAutoRenew",
                "DisableDomainTransferLock",
                "EnableDomainAutoRenew",
                "EnableDomainTransferLock",
                "RegisterDomain",
                "RenewDomain",
                "ResendContactReachabilityEmail",
                "RetrieveDomainAuthCode",
                "TransferDomain",
                "UpdateDomainContact",
                "UpdateDomainContactPrivacy",
                "UpdateDomainNameservers"
            ],
            "List": [
                "ListDomains",
                "ListOperations",
                "ListTagsForDomain"
            ]
        };
    }
    /**
     * (experimental) Grants permission to check the availability of one domain name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainAvailability.html
     *
     * @experimental
     */
    toCheckDomainAvailability() {
        return this.to('CheckDomainAvailability');
    }
    /**
     * (experimental) Grants permission to delete the specified tags for a domain.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteTagsForDomain.html
     *
     * @experimental
     */
    toDeleteTagsForDomain() {
        return this.to('DeleteTagsForDomain');
    }
    /**
     * (experimental) Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     *
     * @experimental
     */
    toDisableDomainAutoRenew() {
        return this.to('DisableDomainAutoRenew');
    }
    /**
     * (experimental) Grants permission to remove the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainTransferLock.html
     *
     * @experimental
     */
    toDisableDomainTransferLock() {
        return this.to('DisableDomainTransferLock');
    }
    /**
     * (experimental) Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     *
     * @experimental
     */
    toEnableDomainAutoRenew() {
        return this.to('EnableDomainAutoRenew');
    }
    /**
     * (experimental) Grants permission to set the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_EnableDomainTransferLock.html
     *
     * @experimental
     */
    toEnableDomainTransferLock() {
        return this.to('EnableDomainTransferLock');
    }
    /**
     * (experimental) For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to get information about whether the registrant contact has responded.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetContactReachabilityStatus.html
     *
     * @experimental
     */
    toGetContactReachabilityStatus() {
        return this.to('GetContactReachabilityStatus');
    }
    /**
     * (experimental) Grants permission to get detailed information about a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainDetail.html
     *
     * @experimental
     */
    toGetDomainDetail() {
        return this.to('GetDomainDetail');
    }
    /**
     * (experimental) Grants permission to get a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainSuggestions.html
     *
     * @experimental
     */
    toGetDomainSuggestions() {
        return this.to('GetDomainSuggestions');
    }
    /**
     * (experimental) Grants permission to get the current status of an operation that is not completed.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html
     *
     * @experimental
     */
    toGetOperationDetail() {
        return this.to('GetOperationDetail');
    }
    /**
     * (experimental) Grants permission to list all the domain names registered with Amazon Route 53 for the current AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListDomains.html
     *
     * @experimental
     */
    toListDomains() {
        return this.to('ListDomains');
    }
    /**
     * (experimental) Grants permission to list the operation IDs of operations that are not yet complete.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html
     *
     * @experimental
     */
    toListOperations() {
        return this.to('ListOperations');
    }
    /**
     * (experimental) Grants permission to list all the tags that are associated with the specified domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListTagsForDomain.html
     *
     * @experimental
     */
    toListTagsForDomain() {
        return this.to('ListTagsForDomain');
    }
    /**
     * (experimental) Grants permission to register domains.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RegisterDomain.html
     *
     * @experimental
     */
    toRegisterDomain() {
        return this.to('RegisterDomain');
    }
    /**
     * (experimental) Grants permission to renew domains for the specified number of years.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RenewDomain.html
     *
     * @experimental
     */
    toRenewDomain() {
        return this.to('RenewDomain');
    }
    /**
     * (experimental) For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to resend the confirmation email to the current email address for the registrant contact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendContactReachabilityEmail.html
     *
     * @experimental
     */
    toResendContactReachabilityEmail() {
        return this.to('ResendContactReachabilityEmail');
    }
    /**
     * (experimental) Grants permission to get the AuthCode for the domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RetrieveDomainAuthCode.html
     *
     * @experimental
     */
    toRetrieveDomainAuthCode() {
        return this.to('RetrieveDomainAuthCode');
    }
    /**
     * (experimental) Grants permission to transfer a domain from another registrar to Amazon Route 53.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomain.html
     *
     * @experimental
     */
    toTransferDomain() {
        return this.to('TransferDomain');
    }
    /**
     * (experimental) Grants permission to update the contact information for domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContact.html
     *
     * @experimental
     */
    toUpdateDomainContact() {
        return this.to('UpdateDomainContact');
    }
    /**
     * (experimental) Grants permission to update the domain contact privacy setting.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContactPrivacy.html
     *
     * @experimental
     */
    toUpdateDomainContactPrivacy() {
        return this.to('UpdateDomainContactPrivacy');
    }
    /**
     * (experimental) Grants permission to replace the current set of name servers for a domain with the specified set of name servers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html
     *
     * @experimental
     */
    toUpdateDomainNameservers() {
        return this.to('UpdateDomainNameservers');
    }
    /**
     * (experimental) Grants permission to add or update tags for a specified domain.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateTagsForDomain.html
     *
     * @experimental
     */
    toUpdateTagsForDomain() {
        return this.to('UpdateTagsForDomain');
    }
    /**
     * (experimental) Grants permission to get all the domain-related billing records for the current AWS account for a specified period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ViewBilling.html
     *
     * @experimental
     */
    toViewBilling() {
        return this.to('ViewBilling');
    }
}
exports.Route53domains = Route53domains;
_a = JSII_RTTI_SYMBOL_1;
Route53domains[_a] = { fqn: "iam-floyd.Route53domains", version: "0.165.0" };
//# sourceMappingURL=data:application/json;base64,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